# dictformat-cannadic.rb: Converter module for cannadic format.
# $Id: $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/prime-config'
require 'prime/makedict/dictformat'
$KCODE = 'e'

class DictFormatCannadic < DictFormat
  
  def initialize (filename_postable = nil)
    super()
    filename_postable = (filename_postable or
                           PRIME_DATA_DIR + "/makedict/canna2prime.table")
    @pos_table = {}
    File::open(filename_postable, "r").each {|line|
      (pos_prime, pos_canna) = line.chomp.split(/\t/)
      @pos_table[pos_canna] = pos_prime
    }
  end

  def parse (line)
    line.chomp!
    words = []
    (pron, *data) = line.split(/ /)
    
    while data.first do
      (canna_pos, freq) = data.shift.split('*')
      pos = @pos_table[canna_pos]
      while data.first and (data.first !~ /^\#/) do
	literal = data.shift
	if (pos.nil? and $DEBUG) then
	  puts "Unknown pos: #{pron}, #{literal}, #{canna_pos}" 
	end
	if pos != "-" then
	  words << [pron, pos, literal, freq]
	end
      end
    end
    return words
  end
end

