<?php

/*
 * postLdapAdmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ѥ桼
 *
 * $RCSfile: admin_user_mod.php,v $
 * $Revision: 1.35 $
 * $Date: 2009/06/19 00:36:01 $
 **********************************************************/

include_once("../../lib/libcommon");
include_once("../../lib/libpage");
include_once("../../lib/libsess");
include_once("../../lib/libldap");
include_once("../../lib/libuser");

/********************************************************
ƥڡ
*********************************************************/

/* ֤μ */
define("MY_TAB", TAB_USER);

/* ѥ󤯤ꥹ */
$topic[0]["name"] = TOPIC_USER_CONTROL;
$topic[0]["url"] = "admin_user_menu.php";
$topic[1]["name"] = TOPIC_USER_SEARCH_MOD;
$topic[1]["url"] = "admin_user_search.php";
$topic[2]["name"] = TOPIC_USER_EDIT;
$topic[2]["url"] = "";

define("OPERATION", "桼");
define("MODE_LDAPDATA", 0);
define("MODE_POSTDATA", 1);

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {

        global $sesskey;
        global $user;
        global $dispusr;
        global $mode;
        global $ldapdata;
        global $userdn;

        /* DNΰŹ沽 */
        $userdn = base64_encode($userdn);
        $userdn = str_rot13($userdn);

        /* 桼̾ΰŹ沽 */
        $form_name = base64_encode($_POST["name"]);
        $form_name = str_rot13($form_name);

        /* hiddenϤǡǼ */
        $hiddendata['dn'] = $userdn;
        $hiddendata['sk'] = $sesskey;
        $hiddendata['page'] = $_POST["page"];
        $hiddendata['filter'] = $_POST["filter"];
        $hiddendata['form_name'] = $form_name;
        $hiddendata['name_match'] = $_POST['name_match'];

        if ($mode == MOD_MODE) {

            $postdata['user'] = $user;
            if (isset($ldapdata[0]["quotaSize"][0])) {
                $postdata['quota'] = to_MB($ldapdata[0]["quotaSize"][0]);
            }
 
            /* ž襢ɥ쥹˼ʬΥɥ쥹С
            Ф˥᡼ĤꡢʤлĤʤ */
            if (isset ($ldapdata[0]['mailForwardingAddr'][1])) {
                 $postdata['save'] = ON;
                 if ($ldapdata[0]['mail'][0] == $ldapdata[0]['mailForwardingAddr'][0]) {
                     $postdata['trans'] = $ldapdata[0]['mailForwardingAddr'][1];
                 } else {
                     $postdata['trans'] = $ldapdata[0]['mailForwardingAddr'][0];
                 }
            } else if (isset ($ldapdata[0]['mailForwardingAddr'][0])) {
                 $postdata['save'] = OFF;
                 $postdata['trans'] = $ldapdata[0]['mailForwardingAddr'][0];
            } 

            /* ᡼륨ꥢʬ */
            if (isset($ldapdata[0]['mailAlias'][0])) {
                $ldapalias = htmlspecialchars($ldapdata[0]['mailAlias'][0]);
                $part = explode("@", $ldapalias, 2);
                $postdata['alias'] = $part[0];
            }
        } elseif ($mode == POST_MOD_MODE) {
            $postdata = $_POST;
        }

        print_admin_form($mode, $postdata, $hiddendata);

    }

};

/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg  = new my_page();
if (isset($_POST["sk"])) {
    $sesskey = $_POST["sk"];
} 

/* 桼Ǽ */
if (isset($_POST["dn"])) {
    $userdn = $_POST["dn"];
    $userdn = str_rot13($userdn);
    $userdn = base64_decode($userdn);
}
if (isset($_POST["page"])) {
    $page = $_POST["page"];
}
if (isset($_POST["filter"])) {
    $filter = $_POST["filter"];
}

/* ɥᥤ */
$domain = $_SERVER['DOMAIN'];

/* եɹ */
$ret = read_web_conf();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* Ź沽Υѥ򥻥å */
$admkey_file = BASEDIR . ETCDIR . $domain . "/" . ADMKEY;

/* å */
if (isset($sesskey) === FALSE) {
    header("Location: index.php?e=2");
    exit (1);
}

/* åå */
if (is_sysadm($sesskey) !== TRUE) {
   header("Location: index.php?e=1");
   exit (1);
}

/* 顼å */
$err_msg = "";

/***********************************************************
 * main
 **********************************************************/
/* ʬ */
/* ڡηå */
if (is_num_check($page) === FALSE) {
    $err_msg = "ڡͤǤ";
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* ե륿ʣ粽 */
if (sess_key_decode($filter, $dec_filter) === FALSE) {
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* ե륿ηå */
$fdata = explode(':', $dec_filter);
if (count($fdata) != 3) {
    $err_msg = "ե륿ηǤ";
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* DNηå */
$len = (-1) * strlen($web_conf['ldapbasedn']);
$cmpdn = substr($userdn, $len);
if (strcmp($cmpdn, $web_conf['ldapbasedn']) != 0) {
    $err_msg = "DNηǤ";
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* 桼μ */
$ret = get_userdata($userdn);
if ($ret === FALSE) {
    if (isset ($_POST['delete'])) {
        $err_msg = "ꤵ줿桼ϤǤ˺Ƥޤ";
    }
    result_log(OPERATION . ":NG:" . $err_msg);
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

$user = $ldapdata[0]["uid"][0];

$dispattr = $web_conf['displayuser'];
$dispusr = $ldapdata[0][$dispattr][0];

/* եǼ */
$form_name = $_POST["form_name"];
$name_match = $_POST["name_match"];

if (isset($_POST['modify'])) {

    /* ⡼ */
    $mode = POST_MOD_MODE;

    /* ѹѥǡ */
    $data = $_POST;
    $data["mail"] = $ldapdata[0]["mail"][0];
    $data["uid"] = $ldapdata[0]["uid"][0];

    /* ϥǡΥå */
    if (check_mod_data($data) === FALSE ||
        mod_user($data) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        $err_msg = "桼򹹿ޤ(" . $dispusr . ")";
        result_log(OPERATION . ":OK:" . $err_msg);

        /* ̤ */
        dgp_location_search("admin_user_search.php", $err_msg);
        exit;
    }
} elseif (isset($_POST["delete"])) {

    $mode = POST_MOD_MODE;

    /* 桼 */
    if ($user != "" && del_user($user) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        $err_msg = "桼ޤ(" . $dispusr . ")";
        result_log(OPERATION . ":OK:" . $err_msg);

        /* ̤ */
        dgp_location_search("admin_user_search.php", $err_msg);
        exit;
    }

} elseif (isset($_POST["cancel"])) {

    /* ̤ */
    dgp_location_search("admin_user_search.php", $err_msg);
    exit;

} else {

    /* LDAPǡ⡼ */
    $mode = MOD_MODE;
}



/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display($topic, MY_TAB);

?>
