#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libusage.sh for portsreinstall-upgrade
# - Help messages -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Content of the short help =============
usage_short_content ()
{
	cat << eof
USAGE: ${APPNAME} [OPTIONS] [--] [command]

[OPTIONS]
 <Group 1: Just show messages and exit without operation>
 -H : Show a long help whose content is the same as the manual page.
 -h : Show this short help.
 -V : Show the current version.
 <Group 2: Effective anytime>
 -a : Suppress messages to be batch-friendly.
 -M : Reset group 4 option settings.
 -S : Suppress the credit and opening messages.
 <Group 3: Saved and transferred to restarted runs, renewable by -M option>
 -c : Suppress cleaning the temporary database even if its obsolete.
 -n : No operation is carried out (just for seeing what will be done).
 <Group 4: Saved and not renewable until cleaning>
 -P : Directory where the updated packages are located (\${PACKAGES}/\${PKGREPOSITORYSUBDIR} by default (which is usually /usr/ports/packages/All)

[ARGUMENTS]
 command:database_maintain_save
            do (default)
          | clean [normal] | clean force
          | options

[DESCRIPTIONS]
 This utility is dispatched from a builder environment to target environments for upgrading packages.

[ROBUSTNESS AGAINST TERMINATION AND RESTART]
 Execution of this utility can be terminated at any points and restarted from there with the same options saved in the temporary database (independent among utilities). The saved options can be changed by the ways depending on the assigned groups of the options. The options and execution progress are reset to the default by running with "-R" option.
eof
}
