#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libtemp.sh
# - Temporary directory and signal trapping -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Warn when the temporary database is obsolete =============
temp_warn_obsolete_temp_db ()
{
	[ "x${DATABASE_IS_OBSOLETE}" = xyes ] || return 0
	message_echo "WARNING: The Ports tree was updated after construction of the temporary database for ${APPNAME}."
	message_echo "You should consider executing "
	message_echo "        ${APPNAME} reset keepstatus"
	message_echo "to reset the temporary database unless you have special purposes."
}
