#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - String processing -
# Copyright (C) 2013-2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Escape characters for the extended regular expression (by stream interface) =============
str_escape_regexp_filter ()
{
	sed 's/\\/\\\\/g;s/|/\\|/g;s/\./\\./g;s|/|\\/|g;s/\[/\\[/g;s/\]/\\]/g;s/[(]/\\(/g;s/[)]/\\)/g;s/\+/\\+/g;s/\?/\\?/g;s/\*/\\*/g;s/\^/\\^/g;s/\$/\\$/g'
}

# ============= Escape characters for the extended regular expression (by argument interface) =============
str_escape_regexp ()
{
	echo "$*" | str_escape_regexp_filter
}

# ============= Escape characters for replacement used with the extended regular expression (by stream interface) =============
str_escape_replaceval_filter ()
{
	sed 's/\\/\\\\/g;s/&/\\&/g;s|/|\\/|g'
}

# ============= Escape characters for replacement used with the extended regular expression (by argument interface) =============
str_escape_replaceval ()
{
	echo -n "$*" | str_escape_replaceval_filter
}

# ============= Convert a glob pattern into a pattern for the extended regular expression =============
str_convert_glob_to_regexp_pattern ()
{
	sed 's/\+/\\+/g;s/\./\\./g;s|/|\\/|g;s/\*/.*/g;s/\?/g./;s/\[\!/[^/g;s/^/^/;s/$/$/'
}

# ============= Convert a ports glob pattern into a pattern for the extended regular expression =============
str_convert_portsglob_to_regexp_pattern ()
{
	local glob_pattern regexp_pattern
	glob_pattern=$1
	if expr "$glob_pattern" : '^:' > /dev/null 2>&1
	then
		regexp_pattern=`echo "$glob_pattern" | sed 's/^://'`
	else
		regexp_pattern=`echo "$glob_pattern" | str_convert_glob_to_regexp_pattern`
	fi
	echo "$regexp_pattern"
}

# ============= Compose a part of sentence by concatenating items in a list as a logical product =============
str_linearize_list_and ()
{
	echo "$*" | sed -E 's/^ +//; s/ +$//; s/ +/, /g; s/, ([^ ]+)$/ and \1/'
}

# ============= Manipulate a flavored origin name from a diretory path =============
str_dirpath_to_origin ()
{
	local dbpath portname catpath catname
	dbpath=$1
	portname=`basename "$dbpath"`
	catpath=`dirname "$dbpath"`
	catname=`basename "$catpath"`
	echo "$catname/$portname"
}

# ============= Concatenate a space/linefeed separated list to a apart of sentence =============
str_concat_items_for_sentence ()
{
	sed 's/$/,/' | tr '\n' ' ' | sed -E 's/, $//;s/, ([^ ]*)$/ and \1/'
}
