#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Commands of flexible configuration -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Register/deregister ok ports in the command line form =============
command_flexconf_update_ok ()
{
	local dbfile tmp_manually_done_diff
	dbfile=${DBDIR}/manually_done.list
	[ -e "$dbfile" ] || touch "$dbfile"
	cp "$dbfile" "$dbfile.tmp"
	shift || :
	case $COMMAND_OPERATION in
	add )
		pkgsys_register_evaluated_globs add "$dbfile.tmp" "$@"
		message_echo "`str_linearize_list_and \"$*\"` is/are registered to the list of manually resolved ports"
		;;
	del )
		pkgsys_register_evaluated_globs remove "$dbfile.tmp" "$@"
		message_echo "`str_linearize_list_and \"$*\"` is/are deregistered from the list of manually resolved ports"
		program_deregister_stage_complete REINSTALLATION
		program_deregister_stage_complete ALL_COMPLETE
		;;
	esac
	tmp_manually_done_diff=${TMPDIR}/command_flexconf_update_ok:manually_done.list.diff
	if fileedit_manipulate_old_new_lines "$dbfile" "$dbfile.tmp" \
		"$tmp_manually_done_diff.old" "$tmp_manually_done_diff.new"
	then
		while read origin
		do
			database_record_failure "$origin"
		done < $tmp_manually_done_diff.old
		while read origin
		do
			database_record_success "$origin"
		done < $tmp_manually_done_diff.new
	fi
	mv "$dbfile.tmp" "$dbfile"
	message_echo "Now the following ports have been manually resolved:"
	message_cat "$dbfile"
}

# ============= Register/deregister taboo ports in the command line form =============
command_flexconf_update_taboo ()
{
	local COMMAND_OPERATION evalated_globs
	COMMAND_OPERATION=$1
	shift || :
	evalated_globs=`str_linearize_list_and "$@"`
	case $COMMAND_OPERATION in
	add )
		pkgsys_register_evaluated_globs add "${DBDIR}/taboo.list" "$@"
		message_echo "$evalated_globs is/are registered to the list of taboo ports."
		;;
	del )
		pkgsys_register_evaluated_globs remove "${DBDIR}/taboo.list" "$@"
		message_echo "$evalated_globs is/are deregistered from the list of taboo ports."
		;;
	esac
	fileedit_combine_lists "${DBDIR}/conf/TABOO:PORTS.parsed" "${DBDIR}/taboo.list" > ${DBDIR}/taboo.all.list
	message_echo "Now the following ports are registered as taboo:"
	message_cat "${DBDIR}/taboo.all.list"
}

# ============= Register/deregister freeze ports in the command line form =============
command_flexconf_update_freeze ()
{
	local COMMAND_OPERATION evalated_globs
	COMMAND_OPERATION=$1
	shift || :
	evalated_globs=`str_linearize_list_and "$@"`
	case $COMMAND_OPERATION in
	add )
		pkgsys_register_evaluated_globs add "${DBDIR}/freeze.list" "$@"
		message_echo "$evalated_globs is/are registered to the list of ports to freeze."
		;;
	del )
		pkgsys_register_evaluated_globs remove "${DBDIR}/freeze.list" "$@"
		message_echo "$evalated_globs is/are deregistered from the list of ports to freeze."
		;;
	esac
	fileedit_combine_lists "${DBDIR}/conf/FREEZE:PORTS.parsed" "${DBDIR}/freeze.list" > ${DBDIR}/freeze.all.list
	message_echo "Now the following ports are registered to freeze:"
	message_cat "${DBDIR}/freeze.all.list"
}

# ============= Register/deregister needed ports in the command line form =============
command_flexconf_update_need ()
{
	local COMMAND_OPERATION evalated_globs
	COMMAND_OPERATION=$1
	shift || :
	evalated_globs=`str_linearize_list_and "$@"`
	case $COMMAND_OPERATION in
	add )
		pkgsys_register_evaluated_globs add "${DBDIR}/need.list" "$@"
		message_echo "$evalated_globs is/are registered to the list of necessary ports."
		;;
	del )
		pkgsys_register_evaluated_globs remove "${DBDIR}/need.list" "$@"
		message_echo "$evalated_globs is/are deregistered from the list of necessary ports."
		;;
	esac
	{
		sed -E -f "${DBDIR}/REPLACE.complete_sed_pattern" "${DBDIR}/need.list" || :
		cat "${DBDIR}/need.list" || :
	} 2> /dev/null | sort -u > ${DBDIR}/need.with_replaced.list
	message_echo "Now the following ports are registered to be necessary:"
	message_cat "${DBDIR}/need.list"
}

# ============= Register/deregister unneeded ports in the command line form =============
command_flexconf_update_noneed ()
{
	local COMMAND_OPERATION evalated_globs
	COMMAND_OPERATION=$1
	shift || :
	evalated_globs=`str_linearize_list_and "$@"`
	case $COMMAND_OPERATION in
	add )
		pkgsys_register_evaluated_globs add "${DBDIR}/noneed.list" "$@"
		message_echo "$evalated_globs is/are registered to the list of unnecessary ports."
		;;
	del )
		pkgsys_register_evaluated_globs remove "${DBDIR}/noneed.list" "$@"
		message_echo "$evalated_globs is/are deregistered from the list of unnecessary ports."
		;;
	esac
	message_echo "Now the following ports are registered to be unnecessary:"
	message_cat "${DBDIR}/noneed.list"
}
