#!/bin/sh -e
# ==============================================================================
# portsreinstall-chroot library script
# Overlay onto lib/libdatabase_maintain.sh for portsreinstall-chroot
# - Operations on the temporary database -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Destroy the builder chroot environment and clean up the temporary database =============
database_clean_destroy ()
{
	local systembase
	systembase=$1
	message_echo "Starting to clean up the builder chroot environment..."
	fs_destroy "$systembase"
	message_echo "Starting to clean up the temporary database..."
	command_exec_without_pkgtools__notify_reset_options
	rm -rf "${DBDIR}"
	message_echo "Done"
}

# ============= Forcibly destroy the builder chroot environment and clean up the temporary database =============
database_clean_destroy_force ()
{
	[ -e "${DBDIR}/saved_options.sh" ] && . "${DBDIR}/saved_options.sh"
	database_clean_destroy
}
