#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libcommand.sh for portsreinstall-chroot
# - Operations of commands as well as check of command line arguments -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Check the necessity of opening notice =============
command_all_chk_need_opening_notice ()
{
	false
}

# ============= Execute command operations before getting the temporary database ready =============
command_all_exec_before_db_creation ()
{
	local COMMAND_RESTART COMMAND_MODE COMMAND_OPERATION
	COMMAND_RESTART="$@"
	COMMAND_MODE=${1:-do}
	shift || :
	case $COMMAND_MODE in
	clean )
		COMMAND_OPERATION=${1:-normal}
		shift || :
		_command_parse_args__chk_no_arg $#
		case $COMMAND_OPERATION in
		force )
			database_clean_destroy_force
			exit
			;;
		esac
		;;
	esac
}

# ============= Check and parse command line arguments =============
command_all_parse_args ()
{
	local num_args_init
	num_args_init=$#
	COMMAND_RESTART="$@"
	COMMAND_MODE=${1:-do}
	shift || :
	case $COMMAND_MODE in
	clean )
		COMMAND_OPERATION=${1:-normal}
		shift || :
		case $COMMAND_OPERATION in
		normal )
			misc_chk_privilege
			;;
		esac
		_command_parse_args__chk_no_arg $#
		;;
	do | mount | unmount | enter | sync | options )
		misc_chk_privilege
		_command_parse_args__chk_no_arg $#
		;;
	*)
		message_echo "ERROR: Invalid command [$COMMAND_MODE]." >&2
		exit 1
		;;
	esac
	COMMAND_SHIFT=$(($num_args_init - $#))
}

# ============= Execute command operations which should be done without upgrade of tools =============
command_all_exec_before_tools_upgrade ()
{
	case $COMMAND_MODE in
	clean )
		database_clean_destroy
		exit
		;;
	unmount )
		fs_terminate_if_unmount_unavailable
		fs_unmount
		exit
		;;
	mount )
		command_do_chroot_cleanup
		fs_build_chroot
		fs_terminate_if_mount_unavailable
		fs_mount
		temp_reset_termination_messages_common
		message_echo "Done"
		exit
		;;
	enter )
		command_do_chroot_cleanup
		fs_build_chroot
		fs_terminate_if_mount_unavailable
		fs_mount
		command_do_chroot_enter
		message_echo "Exited successfully"
		program_deregister_stage_complete UPGRADE_GUEST
		exit
		;;
	sync )
		command_do_chroot_cleanup
		fs_build_chroot
		fs_terminate_if_mount_unavailable
		fs_mount
		command_do_update_host_files
		message_echo "Done"
		exit
		;;
	options )
		options_show_all
		exit
		;;
	esac
}

# ============= Execute command operations as the main process =============
command_all_exec_main ()
{
	case $COMMAND_MODE in
	do)
		command_do_main
		command_do_ending_process
		;;
	esac
}
