#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Program control -
# Copyright (C) 2013-2015 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Variables =============
PROGRAM_DEPENDS=	# Processes on which the current process depends
PROGRAM_NUM_STEPS=	# [Used in _program_exec_restartable_loop_operation__routine] Total number of routine steps
PROGRAM_STEP_PROGRESS=	# [Used in _program_exec_restartable_loop_operation__routine] Current progress as the finished number of routine steps
PROGRAM_STEP_COUNTER=	# [Used in _program_exec_restartable_loop_operation__routine] Counter string indicating the current progress
PROGRAM_STAGETAG=	# [Used in _program_exec_restartable_loop_operation__routine] Current stage tag

# ============= Check completion of a stage =============
program_chk_stage_complete ()
{
	local stagetag
	stagetag=$1
	[ -e "${DBDIR}/stage.complete/$stagetag" ]
}

# ============= Check completion of a loop in a stage =============
program_chk_stage_loop_complete ()
{
	local stagetag
	stagetag=$1
	program_chk_stage_complete "$stagetag" && return
	[ -e "${DBDIR}/stage.reinit_loop/$stagetag" ]
}

# ============= Register completion of a stage =============
program_register_stage_complete ()
{
	local stagetag
	stagetag=$1
	rm -f "${DBDIR}/stage.reinit_loop/$stagetag"
	[ -d "${DBDIR}/stage.complete" ] || mkdir -p "${DBDIR}/stage.complete"
	touch "${DBDIR}/stage.complete/$stagetag"
}

# ============= Reset the loop counter of a stage =============
program_reset_loop_for_stage ()
{
	local stagetag
	stagetag=$1
	[ -d "${DBDIR}/stage.reinit_loop" ] || mkdir -p "${DBDIR}/stage.reinit_loop"
	touch "${DBDIR}/stage.reinit_loop/$stagetag"
}

# ============= Deregister completion of a stage =============
program_deregister_stage_complete ()
{
	local stagetag
	stagetag=$1
	program_reset_loop_for_stage "$stagetag"
	rm -f "${DBDIR}/stage.complete/$stagetag"
}

# ============= Register stages on which a stage depends =============
program_register_stage_depends ()
{
	local stagetag prefix_rpl
	stagetag=$1
	shift
	[ -d "${DBDIR}/stage.depends" ] || mkdir -p "${DBDIR}/stage.depends"
	prefix_rpl=`str_escape_replaceval "${DBDIR}/stage.depends/"`
	while [ $# -gt 0 ]
	do
		fileedit_add_a_line_if_new "$stagetag" "${DBDIR}/stage.depends/$1"
		shift
	done
}

# ============= Reset stages which depend on a stage =============
program_reset_depending_stages ()
{
	local stagetag prefix_rpl
	stagetag=$1
	[ -e "${DBDIR}/stage.depends/$stagetag" ] || return 0
	while read stagetag_dependent
	do
		program_deregister_stage_complete "$stagetag_dependent"
	done < ${DBDIR}/stage.depends/$stagetag
}

# ============= Define the default operation for program_exec_and_record_completion =============
program_reset_exec_and_record_completion_operation ()
{
	_program_exec_and_record_completion__operation ()
	{
		echo "ERROR: [Internal] _program_exec_and_record_completion__operation is undefined." .&2
		exit 1
	}
	PROGRAM_DEPENDS=
}
program_reset_exec_and_record_completion_operation

# ============= Execute an operation and record its completion =============
program_exec_and_record_completion ()
{
	local stagetag PROGRAM_IS_LOOP_TO_BE_INIT
	stagetag=$1
	shift
	if ! program_chk_stage_complete "$stagetag"
	then
		PROGRAM_STAGETAG=$stagetag
		program_register_stage_depends "$stagetag" $PROGRAM_DEPENDS
		_program_exec_and_record_completion__operation "$@"
		program_reset_depending_stages "$stagetag"
		program_register_stage_complete "$stagetag"
	fi
	program_reset_exec_and_record_completion_operation
}

# ============= Define the default operation for program_exec_and_record_completion =============
program_reset_exec_restartable_loop_operation ()
{
	_program_exec_restartable_loop_operation__routine ()
	{
		local item
		item=$1
		echo "ERROR: [Internal] _program_exec_restartable_loop_operation__routine is undefined." .&2
		exit 1
	}
}
program_reset_exec_restartable_loop_operation

# ============= Execute a restartable loop operation =============
program_exec_restartable_loop_operation ()
{
	local inputdb tmp_diff looplist nlines PROGRAM_NUM_STEPS PROGRAM_STEP_PROGRESS iline item
	inputdb=$1
	tmp_diff=${TMPDIR}/program_exec_restartable_loop_operation:diff
	looplist=${DBDIR}/stage.loop_list/$inputdb
	if fileedit_manipulate_new_lines "$looplist.prev" "$looplist" > $looplist.remain.new
	then
		if [ -f "$looplist.remain" -a ! -e "${DBDIR}/stage.reinit_loop/$PROGRAM_STAGETAG" ]
		then
			cp "$looplist.remain" "$looplist.remain.tmp"
			cat "$looplist.remain.new" >> $looplist.remain.tmp
			sort -u "$looplist.remain.tmp" >  $looplist.remain.tmp2
			mv "$looplist.remain.tmp2" "$looplist.remain"
		fi
		cat "$looplist" 2> /dev/null > $looplist.tmp || :
		mv "$looplist.tmp" "$looplist.prev"
	fi
	if [ -f "$looplist.remain" -a ! -e "${DBDIR}/stage.reinit_loop/$PROGRAM_STAGETAG" ]
	then
		message_restarted_process
	else
		cat "$looplist" 2> /dev/null > $looplist.remain.tmp || :
		mv "$looplist.remain.tmp" "$looplist.remain"
		rm -f "${DBDIR}/stage.reinit_loop/$PROGRAM_STAGETAG"
	fi
	cp "$looplist.remain" "${TMPDIR}/$inputdb.input"
	PROGRAM_NUM_STEPS=`cat "$looplist" 2> /dev/null | wc -l | tr -d ' '` || :
	nlines=`wc -l < ${TMPDIR}/$inputdb.input`
	PROGRAM_STEP_PROGRESS=$(($PROGRAM_NUM_STEPS-$nlines))
	iline=1
	while [ $iline -le $nlines ]
	do
		item=`sed -n ${iline}p "${TMPDIR}/$inputdb.input"`
		iline=$(($iline+1))
		PROGRAM_STEP_PROGRESS=$(($PROGRAM_STEP_PROGRESS+1))
		PROGRAM_STEP_COUNTER="[$PROGRAM_STEP_PROGRESS/$PROGRAM_NUM_STEPS $(($PROGRAM_STEP_PROGRESS*100/$PROGRAM_NUM_STEPS))%]"
		grep -q -E "^`str_escape_regexp \"$item\"`$" "$looplist.remain" 2> /dev/null || continue
		_program_exec_restartable_loop_operation__routine "$item"
		fileedit_rm_a_line "$item" "$looplist.remain"
	done
	program_reset_exec_restartable_loop_operation
}
