<?php
/*
 * This file is part of the PokoX package.
 * Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For license information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: test.PokoXError.php,v 1.1 2005/07/17 05:32:33 fenjin Exp $
 */

require_once('PokoXError.class.php');
require_once("PHPUnit.php");

/**
 * PokoXError 饹Υƥȥ
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @subpackage Utility
 * @since 1.1
 */
class PokoXErrorTest extends PHPUnit_TestCase
{
	function testRaise()
	{
		PokoXError::raise(array(
			'msg' => 'Message1',
			'no' => 1,
			'file' => __FILE__,
			'line' => __LINE__));
		PokoXError::raise(array(
			'msg' => 'Message2',
			'no' => 2,
			'file' => __FILE__,
			'line' => __LINE__));
		$this->assertEquals(2, PokoXError::count());
	}

	function testAll()
	{
		$this->assertEquals(2, count(PokoXError::all()));
	}

	function testPop()
	{
		$error = PokoXError::pop();
		$this->assertEquals(2, $error['no']);
		$error = PokoXError::last();
		$this->assertEquals(1, $error['no']);
		$this->assertEquals(0, PokoXError::count());
	}

	function testClear()
	{
		PokoXError::raise(array(
			'msg' => 'Message3',
			'no' => 3,
			'file' => __FILE__,
			'line' => __LINE__));
		PokoXError::raise(array(
			'msg' => 'Message4',
			'no' => 4,
			'file' => __FILE__,
			'line' => __LINE__));
		PokoXError::clear();
		$this->assertEquals(0, PokoXError::count());
		$this->assertEquals(0, count(PokoXError::all()));
		$this->assertEquals(true, is_array(PokoXError::all()));
	}

}

$suite =& new PHPUnit_TestSuite('PokoXErrorTest');
$result = PHPUnit::run($suite);

// This tips came from http://www.doyouphp.jp/tips/tips_phpunit.shtml(Thanx!)
echo '<pre>';
echo preg_replace(
	"/( failed:.*)/", 
	"<font color=\"red\"><b>\${1}</b></font>", 
	$result->toString());
echo '</pre>';
?>
