<?php
/*
 * This file is part of the PokoX package.
 * Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For license information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: ob_test.php,v 1.1 2005/09/10 10:17:21 fenjin Exp $
 */

/*
 * HTMLϤPokoXХåե¸졢end()ǽˤʤä򼨤
 * ץǤ
 *
 * - GETѥ᡼'LANG'ѿ('SJIS''EUC-JP')˱ơend()HTMLϤ
 * mb_convert_encodingѴƤޤ
 * - ob_start() - ob_end_*()Υߥ󥰤story¦Ǥ褦ˤʤ
 * ޤstart()session_start()ob_start()end()ob_end_*()
 * ޤ
 *
 * 1ܤϡޤHTMLϤʸ褦Ȥ饢ץ¦ǽ
 * ɬפޤ줫ϡĤStoryǽǤץ¦Ǹ
 * ˽ɬפ̵ʤޤ
 *
 * 2ܤˤĤƤǤޤǤϰʲΤ褦ʥɤޤ
 *  ob_start();
 *  echo PokoX::_run(...);
 *  ob_end_flush();
 * åtrans_sidѤ硢 ob_start() -> start_session()
 * ν֤ˤʤäƤޤSID줺trans_sidޤǤ
 * 줫 ob_start()/end_*()Υߥ󥰤Story饹start()end()
 * 줤ФˤǤ褦ˤʤޤ
 *
 * ޤHTMLϤϮʤϤޤ̤end()ǥ롼кޤ
 * ̤Ȥʤޤ
 */

// Smarty 饤֥ꥤ󥹥ȡǥ쥯ȥʴĶ˱ѹ
// (templates_cǥ쥯ȥWeb¹Ը¤ǽ񤭹߲ǽˤƲ)
define('SMARTY_DIR', 
	realpath(dirname(__FILE__)."/../../../Smarty-2.6.9/libs/")
	.DIRECTORY_SEPARATOR);
// NOTICE: SmartyϢϺǸ夬DIRECTORY_SEPARATORǽɬפ롣

require_once(SMARTY_DIR."Smarty.class.php");

require_once("../pokox.inc.php");
require_once("PokoXSmartySampleRenderer.class.php");

if(isset($_GET['LANG']) && is_string($_GET['LANG'])) {
	$LANG = $_GET['LANG'];
} else {
	$LANG = 'EUC-JP'; // Default
}

class OBStory extends PokoXStory {

	function start(&$pokox)
	{
		// session_start() -> ob_start() trans_sidͭˤʤ롣
		// (SID褦ˤʤ뤫顣)
		// դob_start() -> session_start()νSIDʤᤫ
		// trans_sidʤ
		session_name('ob_test');
		session_start();
		ob_start();

		global $LANG;
		if($LANG == 'SJIS') {
			header("Content-Type: text/html; charset=Shift_JIS");
		} else {
			header("Content-Type: text/html; charset=euc-jp");
		}

		if(!isset($_SESSION["POKOX_SESSION_VARS"])) {
			$_SESSION["POKOX_SESSION_VARS"] = array();
		}
		$GLOBALS["_POKOX"] =& $_SESSION["POKOX_SESSION_VARS"];

		global $_POKOX;
		if(!isset($_POKOX["pokox_aci"]))
			$_POKOX["pokox_aci"] = "*";
	}
	
	function story(&$pokox)
	{
		if(isset($_GET[POKOX_STORY_KEY])) {
			$story = $_GET[POKOX_STORY_KEY];
		} else if(isset($_POST[POKOX_STORY_KEY])) {
			$story = $_POST[POKOX_STORY_KEY];
		} else {
			$story = "";
		}

		return $story;
	}
	
	function end(&$pokox)
	{
		global $LANG;
		// öϤԤOutputBufferޤ
		echo $pokox->getContents();
		// OutputBufferƼФȡtrans_sidޤ
		$contents = ob_get_contents();

		// ƥץ졼ȤEUC-JPǤ$LANGSJISλѴޤ
		if($LANG == 'SJIS') {
			$contents = mb_convert_encoding($contents, 'SJIS', 'EUC-JP');
		}
		// OutputBuffer򥯥ꥢХåե󥰤򥹥ȥåפޤ
		ob_end_clean();
		// ѴHTMLǺƥåȤޤ
		$pokox->setContents($contents);
	}
}

class Counter
{
	function execute(&$pokox, $params, $mid = null)
	{
		if(isset($_SESSION['count'])) {
			$_SESSION['count']++;
		} else {
			$_SESSION['count'] = 0;
		}
		$pokox->renderer->assign('count', $_SESSION['count']);

		global $LANG;
		$pokox->renderer->assign('LANG', $LANG);
		return "ob_test_tpl.html";
	}
}

$POKOX_MODULE_STORY = array(
	"*.*" => array("Counter" => array()),
	);

// ob_start()/end_*()ǰϤɬפ⡢ưmb_convert*򵭽Ҥɬפ
// ̵ʤޤ
echo PokoX::_run('OBStory', 'PokoXSmartySampleRenderer');
?>