<?php
/*
 * This file is part of the PokoX package.
 * Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For license information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: PokoXSmartySampleRenderer.class.php,v 1.4 2005/08/08 15:01:09 fenjin Exp $
 */

//
// PokoXSmarty饯饹ץ
//

if(defined('_POKOX_SMARTY_SAMPLE_RENDERER')) return;
define('_POKOX_SMARTY_SAMPLE_RENDERER', 1);


/**
 * Smartyƥץ졼ѥ饯饹ץ
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
class PokoXSmartySampleRenderer extends PokoXRenderer
{
	/**
	 * Smarty֥
	 *
	 * @access public
	 * @type Smarty
	 * @since 1.0
	 */
	var $engine;

	/**
	 * 󥹥ȥ饯
	 *
	 * @access public
	 * @since 1.0
	 */
	function PokoXSmartySampleRenderer()
	{
		$basedir = realpath(dirname(__FILE__));
		$this->engine =& new Smarty();
		$this->engine->left_delimiter = '<{';
		$this->engine->right_delimiter = '}>';
		$this->engine->template_dir = $basedir."/templates/";
		$this->engine->compile_dir = $basedir."/templates_c/";
		$this->engine->plugins_dir = array(
			SMARTY_DIR."/plugins/",
			$basedir."/smarty_plugins/",
			);
		// <{php}><{/php}>λѶػ
		$this->engine->secure = false;
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ
	 * @access public
	 * @since 1.0
	 */
	function assign($name, $value)
	{
		$this->engine->assign($name, $value);
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ͡ʻϤ
	 * @access public
	 * @since 1.0
	 */
	function assign_by_ref($name, &$value)
	{
		$this->engine->assign_by_ref($name, $value);
	}

	/**
	 * ƥץ졼Ƚ᥽å
	 *
	 * @param string ƥץ졼ȥ꥽ʸ
	 * @return string ƥץ졼ȽΥƥʸ
	 * @access public
	 * @since 1.0
	 */
	function parseTemplate($template)
	{
		return $this->engine->fetch($template);
	}
}

?>
