<?php
/**
 * PokoX - Super Light Weight MVC Controller for PHP.
 *
 * @package PokoX
 * @version 1.3.0
 * @copyright Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For LICENSE information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: pokox.inc.php,v 1.10 2005/09/10 09:59:44 fenjin Exp $
 */

if(defined('_POKOX_KERNEL')) return;
/**
 * pokox.inc.php ɤ߹ɻߥե饰
 *
 * @since 1.0
 * @var bool
 */
define('_POKOX_KERNEL', 1);

/*
 * PokoX Ƽ省ʸ
 * !WARNING!
 * GET/POSTΥ̾Ǥ"."ưŪ"_"ѴƤޤ
 * Τᥨ̾ˤȤ륭ʸǤ"."ˤ볬ز
 * ϻԲ!
 */

if(!defined('POKOX_ACI_KEY')) {
/**
 * ACI$_POKOXФΥʸ
 *
 * @since 1.2
 * @var string
 */
define('POKOX_ACI_KEY', 'pokox_aci');
}

if(!defined('POKOX_STORY_KEY')) {
/**
 * ȡ꡼ФΥʸ
 *
 * @since 1.0
 * @var string
 */
define('POKOX_STORY_KEY', 'pokox_story');
}

if(!defined('POKOX_STORY_KEY_PREV')) {
/**
 * ΥڡΥȡ꡼ФΥʸʤС
 *
 * @since 1.0
 * @var string
 */
define('POKOX_STORY_KEY_PREV', 'pokox_story_prev');
}

if(!defined('POKOX_DIR')) {
/**
 * PokoX饤֥ǥ쥯ȥ
 *
 * @since 1.0
 * @var string
 */
define('POKOX_DIR', dirname(__FILE__));
}


if(!defined('POKOX_STORY_DIR')) {
/**
 * PokoXȡ꡼饹ǥ쥯ȥʥǥեȡ
 *
 * @since 1.0
 * @var string
 */
define('POKOX_STORY_DIR', realpath(POKOX_DIR."/story/"));
}

if(!defined('POKOX_STORY_AUTOLOAD')) {
/**
 * ȡ꡼饹μưɤ߹ߵǽON/OFF
 *
 * @since 1.0
 * @var string
 */
define('POKOX_STORY_AUTOLOAD', 1);
}

if(!defined('POKOX_ERROR_LEVEL')) {
/**
 * PokoXνϤ륨顼٥
 *
 * @since 1.0
 * @var string
 */
define('POKOX_ERROR_LEVEL', E_USER_WARNING);
}

/**
 * ȡ꡼⥸塼¹Ԥ
 * ƥץ졼ȥ󤫤ƥץ졼ȥ꥽Ϥ
 * Ϥ롣
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class PokoX
{
	/**
	 * PokoX饤󥹥
	 *
	 * @access public
	 * @since 1.0
	 * @var PokoXRenderer
	 */
	var $renderer = null;

	/**
	 * ⥸塼
	 *
	 * @access private
	 * @since 1.0
	 * @var array
	 */
	var $_modules;

	/**
	 * ⥸塼Υ󥹥󥹥Υå
	 * (idο줿⥸塼Υ󥹥󥹤å롣)
	 *
	 * @access private
	 * @since 1.0
	 * @var array
	 */
	var $_module_stacks;

	/**
	 * dispatchХե饰
	 *
	 * @access private
	 * @since 1.0
	 * @var bool
	 */
	var $_dispatched = false;

	/**
	 * escapeХե饰
	 *
	 * @access private
	 * @since 1.0
	 * @var bool
	 */
	var $_escaped = false;

	/**
	 * escapeΥե饰
	 *
	 * @access private
	 * @since 1.0
	 * @var bool
	 */
	var $_ignore_renderer = false;

	/**
	 * Template꥽̾(PokoXModule)
	 *
	 * @access private
	 * @since 1.2
	 * @var string
	 */
	var $_template_resource = null;

	/**
	 * HTML¸Хåե
	 *
	 * @access private
	 * @since 1.3
	 * @var string
	 */
	var $_contents = null;

	/**
	 * PokoX󥹥󥹤Singletonǥѥ롣
	 *
	 * @return PokoX PokoX󥹥󥹤ؤλ
	 * @access public
	 * @since 1.0
	 */
	function &getInstance()
	{
		static $instance = null;
		if(is_null($instance)) {
			$instance = new PokoX();
		}
		return $instance;
	}

	/**
	 * PokoX ؿ(HTML)
	 *
	 * @param string ȡ꡼ͥ졼饹̾
	 * @param string 饯饹̾
	 * @access public
	 * @since 1.0
	 */
	function run($StoryClassName, $RendererClassName)
	{
		echo PokoX::_run($StoryClassName, $RendererClassName);
	}

	/**
	 * PokoX ؿ
	 *
	 * @param string ȡ꡼ͥ졼饹̾
	 * @param string 饯饹̾(Ѥʤϻ̵)
	 * @return string 
	 * @access public
	 * @since 1.0
	 */
	function _run($StoryClassName, $RendererClassName = null)
	{

		// Create Singleton Instance
		$pokox =& PokoX::getInstance();

		// Load Story Class
		if(!class_exists($StoryClassName)) {
			if(POKOX_STORY_AUTOLOAD) {
				// Story Class File Name
				$sbfn = "/$StoryClassName.class.php";
				if(file_exists(POKOX_STORY_DIR.$sbfn)) {
					require_once(POKOX_STORY_DIR.$sbfn);
				} else {
					user_error(
						"Not found Story Class File for '$StoryClassName'!", 
						POKOX_ERROR_LEVEL
						);
				}
			} else {
				user_error(
					"Not found Story Class '$StoryClassName'!", 
					POKOX_ERROR_LEVEL
					);
			}
		}

		// Load Renderer Class
		if(is_string($RendererClassName) &&
			!class_exists($RendererClassName)) {
			user_error(
				"Not found Renderer Class '$RendererClassName'",
				POKOX_ERROR_LEVEL
				);
		}
		// if Not Speciied Renderer Class, use VarDumpRenderer as Dummy.
		// Renderer Class Instance is created, but parseTemplate() 
		// method doesn't execute at end.
		$_RendererClassName = (is_null($RendererClassName)) ? 
			'PokoXVarDumpRenderer' : $RendererClassName;

		// Create Story Instance
		$story =& new $StoryClassName();
		// Create Renderer Instance
		$pokox->renderer =& new $_RendererClassName();
		// Start Story
		$story->start($pokox);
		// (Re-)Declare $_POKOX Variable as Global Variable
		GLOBAL $_POKOX;
		// Update Previous Story
		if(isset($_POKOX[POKOX_STORY_KEY])) {
			$_POKOX[POKOX_STORY_KEY_PREV] = $_POKOX[POKOX_STORY_KEY];
		}
		// Get Story
		$_POKOX[POKOX_STORY_KEY] = $story->story($pokox);

		// Hook BEFORE Execute Chain
		if(function_exists("POKOX_STORY_PREHOOK")) {
			call_user_func("POKOX_STORY_PREHOOK", $pokox);
		}

		// Get Current Story and ACI
		$pokox_story = (isset($_POKOX[POKOX_STORY_KEY])) ? 
			$_POKOX[POKOX_STORY_KEY] : "*";
		$pokox_aci = (isset($_POKOX[POKOX_ACI_KEY])) ? 
			$_POKOX[POKOX_ACI_KEY] : "*";

		// Invoke Module Chain
		$pokox->_invokeModuleChain($pokox_story, $pokox_aci);

		// Hook AFTER Execute Chain
		if(function_exists("POKOX_STORY_POSTHOOK")) {
			call_user_func("POKOX_STORY_POSTHOOK", $pokox);
		}

		// Update Current Story (for security reason, don't update ACI)
		$pokox_story = (isset($_POKOX[POKOX_STORY_KEY])) ? 
			$_POKOX[POKOX_STORY_KEY] : "*";

		// Assign Auto Template Variables
		$pokox->renderer->assign(
			'POKOX_ACI_KEY', POKOX_ACI_KEY);
		$pokox->renderer->assign(
			'POKOX_STORY_KEY', POKOX_STORY_KEY);
		$pokox->renderer->assign(
			'POKOX_STORY_KEY_PREV', POKOX_STORY_KEY_PREV);
		$pokox->renderer->assign(
			'POKOX_ACI', @$_POKOX[POKOX_ACI_KEY]);
		$pokox->renderer->assign(
			'POKOX_STORY', $_POKOX[POKOX_STORY_KEY]);
		$pokox->renderer->assign(
			'POKOX_STORY_PREV', @$_POKOX[POKOX_STORY_KEY_PREV]);
		
		/*
		 * Not Escaped, or, required renderer control, Execute PokoX Renderer.
		 */
		if((!$pokox->_escaped) || 
			($pokox->_escaped && !$pokox->_ignore_renderer)) {

			// if $this->_template_resource is not null, it overwrites 
			// template story result.
			if(is_null($pokox->_template_resource)) {
				$_trname = $pokox->_parsePokoXDirectives(
					$pokox_aci, $pokox_story, "POKOX_TEMPLATE_STORY");
			} else {
				$_trname = $pokox->_template_resource;
			}

			// Execute PokoXRenderer & Get Output
			if(is_null($RendererClassName) || is_null($_trname)) {
				$contents = null;
			} else {
				$contents = $pokox->renderer->parseTemplate($_trname);
				$pokox->setContents($contents);
			}
		}

		// End Story
		$story->end($pokox);

//		return $contents;
		return $pokox->getContents();
	}

	/**
	 * HTMLϤ򥯥饹Хåե¸롣
	 *
	 * @param string HTML
	 * @access public
	 * @since 1.3
	 */
	function setContents(&$contents)
	{
		$this->_contents = $contents;
	}

	/**
	 * 饹Хåե¸ƤHTMLϤ롣
	 *
	 * @return string HTML
	 * @access public
	 * @since 1.3
	 */
	function &getContents()
	{
		return $this->_contents;
	}

	/**
	 * PokoXϢ󤫤顢ʲ̤ͥ˽äϢĴ١
	 * ҥåȤ餽͡orƥץ졼ȥ꥽ʸˤ֤
	 * <br /><br />
	 * <note>
	 * ̡ͥ"$aci.$story" > "$aci.*" > "*.$story" > "*.*"
	 * </note>
	 *
	 * @param string ߤACI
	 * @param string ߤΥȡ꡼
	 * @param string ϤϢ̾
	 * @return mixed ޤϥƥץ졼ȥ꥽ʸ
	 * @access private
	 * @since 1.0
	 */
	function _parsePokoXDirectives($aci, $story, $directives)
	{
		if(!isset($GLOBALS[$directives]) || is_null($GLOBALS[$directives])) {
			return null;
		}
		foreach($GLOBALS[$directives] as $directive => $value) {
			switch($directive) {
				case "$aci.$story" :
				case "$aci.*" :
				case "*.$story" :
				case "*.*" :
					return $value;
			}
		}
	}

	/**
	 * PokoXModule饹եΥѥ롣
	 *
	 * @param string ǥ쥯ȥ
	 * @param string 饹̾
	 * @return ǥ쥯ȥ.'/'.饹̾.'.class.php'
	 * @access private
	 * @since 1.2
	 */
	function __formatModuleClassFile($path, $class_name)
	{
		return realpath(sprintf('%s/%s.class.php', $path, $class_name));
	}

	/**
	 * PokoXModule饹ɤ롣$POKOX_MODULE_AUTOLOAD_PATH˥⥸塼
	 * 饹եΤǥ쥯ȥ(ʣξ)ꤵƤ
	 * ˡưŪ˥饹եõrequire롣
	 *
	 * @param string 饹̾
	 * @return bool 饹ɺѤߤ饹եrequiretrue.
	 *              饹ե뤬Ĥʤfalse.
	 * @access private
	 * @since 1.2
	 */
	function _loadModuleClass($class_name)
	{
		if(class_exists($class_name)) return true;
		if(!isset($GLOBALS['POKOX_MODULE_AUTOLOAD_PATH'])) return true;

		$paths = $GLOBALS['POKOX_MODULE_AUTOLOAD_PATH'];

		$curdir_fn = PokoX::__formatModuleClassFile('.', $class_name);
		if(file_exists($curdir_fn)) {
			require_once($curdir_fn);
			return true;
		}
		if(is_string($paths)) {
			// single directory path
			$sdp_fn = PokoX::__formatModuleClassFile($paths, $class_name);
			if(file_exists($sdp_fn)) {
				require_once($sdp_fn);
				return true;
			}
		} else if(is_array($paths)) {
			// multiple directory path
			foreach($paths as $path) {
				$mdp_fn = PokoX::__formatModuleClassFile($path, $class_name);
				if(file_exists($mdp_fn)) {
					require_once($mdp_fn);
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * ⥸塼᥽å
	 *
	 * @param string PokoXθߤΥȡ꡼
	 * @param string PokoXθߤACI
	 * @access private
	 * @since 1.2
	 */
	function _initModuleChain($pokox_story, $pokox_aci)
	{
		unset($this->_modules);
		$this->_modules = array();
		if(isset($GLOBALS['POKOX_MODULE_STORY_EX'])) {
			// Extended(Filter Featured) Module Chain Construction
			reset($GLOBALS['POKOX_MODULE_STORY_EX']);
			foreach($GLOBALS['POKOX_MODULE_STORY_EX'] as $key => $value) {
				// Separate aci and story directive
				$_pos = strpos($key, '.');
				$_aci = substr($key, 0, $_pos);
				$_story = substr($key, $_pos+1);
				if(($_aci == $pokox_aci) || ($_aci == "*")) {
					if(preg_match($_story, $pokox_story)) {
						$this->_modules = array_merge(
							$this->_modules, $value);
					}
				}
			}
		} else {
			// Normal Module Chain Construction
			$this->_modules = $this->_parsePokoXDirectives(
				$pokox_aci, $pokox_story, "POKOX_MODULE_STORY");
			if(!isset($this->_modules)) {
				// If not specified current story, initialize as empty array.
				$this->_modules = array();
			}
		}
		reset($this->_modules);
	}

	/**
	 * ⥸塼¹ԥ᥽å
	 *
	 * @param string PokoXθߤΥȡ꡼
	 * @param string PokoXθߤACI
	 * @access private
	 * @since 1.0
	 */
	function _invokeModuleChain($pokox_story, $pokox_aci)
	{
		global $_POKOX;
		// Initialize Module Chain
		$this->_initModuleChain($pokox_story, $pokox_aci);
		do {
			// dispatchե饰̵Ƥ
			if($this->_dispatched) {
				$this->_dispatched = false;
			}
			foreach($this->_modules as $key => $params) {
				$elements = explode('.', $key);
				$class_name = $elements[0];
				if(count($elements) == 2) {
					$mid = $elements[1];
				} else {
					$mid = null;
				}
				$this->_loadModuleClass($class_name);
				$module =& new $class_name();
				$_result = $module->execute($this, $params, $mid);
				if(is_string($_result)) {
					$this->_template_resource = $_result;
				}
				if($mid) {
					// ⥸塼IDؼƤСåѤǤ
					$this->_module_stacks[$mid] =& $module;
				}
				// escapedե饰ͭˤʤäƤнλ
				if($this->_escaped) return;
				// dispatchե饰ͭˤʤäƤХ롼פȴ롣
				if($this->_dispatched) break;
			}
			if($this->_dispatched) {
				// Initialize Module Chain
				$this->_initModuleChain($_POKOX[POKOX_STORY_KEY],
					$_POKOX[POKOX_ACI_KEY]);
			}
		// dispatchͭƤС٥⥸塼¹Ԥ롣
		} while($this->_dispatched);
	}

	/**
	 * ȡ꡼ڤؤȤ(Notify dispatching to new story)
	 *
	 * @access public
	 * @param string ȡ꡼
	 * @since 1.0
	 */
	function dispatch($NewStory)
	{
		global $_POKOX;
		$this->_dispatched = true;
		$_POKOX[POKOX_STORY_KEY] = $NewStory;
	}

	/**
	 * ⥸塼ζλȤ(Notify break module chain)
	 *
	 * @access public
	 * @param bool HTML󥰽򥹥åפ뤫ݤ(Default: true)
	 * @since 1.0
	 */
	function escape($ignore_renderer = true)
	{
		$this->_escaped = true;
		$this->_ignore_renderer = $ignore_renderer;
	}

	/**
	 * ⥸塼륹åѤޤ줿⥸塼륤󥹥󥹤Ф
	 *
	 * @param string ⥸塼ID
	 * @return PokoXModule ⥸塼뤬̵null֤
	 * @access public
	 * @since 1.0
	 */
	function &getStackedModule($mid)
	{
		$pokox =& PokoX::getInstance();
		if(isset($pokox->_module_stacks[$mid])) {
			return $pokox->_module_stacks[$mid];
		} else {
			return null;
		}
	}

	/**
	 * ߤΥ⥸塼륹åλȤ֤
	 *
	 * @return array ߤΥ⥸塼륹åλ
	 * @access public
	 * @since 1.2
	 */
	function &getStackedModules()
	{
		$pokox =& PokoX::getInstance();
		return $pokox->_module_stacks;
	}

	/**
	 * ߤΥ⥸塼򥳥ԡ֤
	 *
	 * @return array ߤΥ⥸塼Υԡ
	 * @access public
	 * @since 1.2
	 */
	function getModuleChain()
	{
		$pokox =& PokoX::getInstance();
		return $pokox->_modules;
	}
}

/**
 * PokoXݡ˥饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
/* interface or abstract */
class PokoXRenderer
{
	/**
	 * ºݤΥƥץ졼ȥ֥
	 *
	 * @access public
	 * @var object
	 * @since 1.0
	 */
	var $engine;

	/**
	 * 󥹥ȥ饯
	 *
	 * @access public
	 * @since 1.0
	 */
	function &PokoXRenderer()
	{
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ
	 * @access public
	 * @since 1.0
	 */
	function assign($name, $value)
	{
		$error = 'PokoXRenderer::assign($name, $value) must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ͡ʻϤ
	 * @access public
	 * @since 1.0
	 */
	function assign_by_ref($name, &$value)
	{
		$error = 'PokoXRenderer::assign_by_ref($name, &$value) must be '
			.'overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ƥץ졼Ƚ᥽å
	 *
	 * @param string ƥץ졼ȥ꥽ʸ
	 * @return string ƥץ졼ȽΥƥʸ
	 * @access public
	 * @since 1.0
	 */
	function parseTemplate($template)
	{
		$error = 'PokoXRenderer::parseTemplate($template) must be ';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
}

/**
 * PokoXȡ꡼Ѵݡ˥饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
/* interface or abstract */
class PokoXStory
{
	/**
	 * ȡ꡼ѥ᥽å
	 *
	 * @access public
	 * @since 1.0
	 */
	function start()
	{
		$error = 'PokoXStory::start() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ȡ꡼᥽å
	 *
	 * @return string ȡ꡼
	 * @access public
	 * @since 1.0
	 */
	function story()
	{
		$error = 'PokoXStory::story() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ȡ꡼λ˼¹Ԥ᥽å
	 *
	 * @access public
	 * @since 1.0
	 */
	function end()
	{
		$error = 'PokoXStory::end() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
}

/**
 * PokoX⥸塼ݡ˥饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
/* interface or abstract */
class PokoXModule
{
	/**
	 * ⥸塼¹ԥ᥽å
	 *
	 * @param PokoX PokoXȥ饪֥ȥ󥹥
	 * @param array ѥ᡼
	 * @param string ʻꤵƤС˥⥸塼ID
	 * @access public
	 * @since 1.0
	 */
	function execute(&$pokox, $params, $mid = null)
	{
		$error = 'PokoXStory::execute(&$pokox, $params, $mid = null) '
			.'must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
}

/**
 * ХåؿPokoX⥸塼<br />
 * 'function' (&$pokox, $params, $mid = null)ΥХåؿƤ֡
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class PokoXUserFuncModule extends PokoXModule
{
	/**
	 * ⥸塼¹ԥ᥽å
	 *
	 * @param PokoX PokoXȥ饪֥ȥ󥹥
	 * @param array ѥ᡼
	 * @param string ʻꤵƤС˥⥸塼ID
	 * @access public
	 * @since 1.0
	 */
	function execute(&$pokox, $params, $mid = null)
	{
		if(isset($params["function"]) && 
			function_exists($params["function"])) {
			call_user_func(
				$params["function"],
				$pokox,
				$params,
				$mid);
		}
	}
}

/**
 * PokoXѥƥȸvar_dump()ʰץ<br />
 * assign줿ͤǸvar_dumpľܽϤޤƥץ졼ȥ꥽
 * ȤޤRendererClassꤵʤΥߡȤƤѤޤ
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class PokoXVarDumpRenderer extends PokoXRenderer
{
	var $engine;
	var $templates;

	function PokoXVarDumpRenderer()
	{
		$this->templates = array();
	}

	function assign($name, $value)
	{
		$this->templates[$name] = $value;
	}

	function assign_by_ref($name, &$value)
	{
		$this->templates[$name] = $value;
	}

	function parseTemplate($template)
	{
		ob_start();
		var_dump($this->templates);
		$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}
}

/**
 * ץPHP(HTML)߼Υƥץ졼ȥ饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class PokoXSimpleRenderer extends PokoXRenderer
{
	/**
	 * ƥץ졼ȤݻϢ
	 *
	 * @access public
	 * @var array
	 * @since 1.0
	 */
	var $engine;

	/**
	 * 󥹥ȥ饯
	 *
	 * @access public
	 * @since 1.0
	 */
	function PokoXSimpleRenderer()
	{
		$this->engine = array();
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ
	 * @access public
	 * @since 1.0
	 */
	function assign($name, $value)
	{
		$this->engine[$name] = $value;
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ͡ʻϤ
	 * @access public
	 * @since 1.0
	 */
	function assign_by_ref($name, &$value)
	{
		$this->engine[$name] = $value;
	}

	/**
	 * ƥץ졼Ƚ᥽å
	 *
	 * @param string ƥץ졼PHP(HTML)ե̾
	 * @return string ƥץ졼ȽΥƥʸ
	 * @access public
	 * @since 1.0
	 */
	function parseTemplate($_template)
	{
		// ƥץ졼$template['name']ȤƼФ褦Х
		// פ˥ԡ롣
		$GLOBALS['template'] = $this->engine;
		// ϥХåե󥰳
		// (ob_start()/ob_end_*()ϥͥȲǽʤΤǡob_start()
		// ĤդƤɬפϤǤ̵
		ob_start();
		require_once($_template);
		$contents = ob_get_contents();
		// ϥХåե󥰽λ&Хåեꥢ
		ob_end_clean();
		// Х륹פ롣
		unset($GLOBALS['template']);
		return $contents;
	}
}
?>
