<?php
/*
 * This file is part of the PokoX package.
 * Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For license information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: PokoXError.class.php,v 1.2 2005/08/11 09:00:48 fenjin Exp $
 */

/**
 * PokoX Error LIFO StackFrame Class (PokoX Utility Classes)
 * <p>
 * ѤΥ顼åե졼९饹raiseǥ顼ϢϤ
 * ̤pop()뤤last()ǼФLIFO(Last In First Out)Υå
 * ե졼ࡣ</p>
 * <p>
 * 顼ϢȤϴ˼ͳǡʹ¤ˤǤ롣</p>
 * <p>
 * count()ǸߥåƤ륨顼οǤ롣all()Ƥ
 * 顼򥳥ԡǤ(åϥꥢʤ)
 * å򥯥ꥢˤclear()Ƥ֡</p>
 * <p>
 * ؿstatic˸ƤӽФ</p>
 *
 * <code>
 * function parent() {
 *     child();
 *     if(PokoXError::count()) {
 *         var_dump(PokoXError::pop()); // or PokoXError::last();
 *     }
 * ...
 *     print_r(PokoXError::all());
 *     PokoXError::clear();
 * }
 * function child() {
 *     ...
 *     PokoXError::raise(array(
 *         'message' => 'your error message',
 *         'code' => 'your error code (integer?)',
 *         'file' => __FILE__,
 *         'line' => __LINE__,
 *         ));
 *     // you can call multiple raise()!
 *     PokoXError::raise(array(
 *         'message' => 'second error message',
 *         'code' => 'seocnd error code',
 *         'code2' => 'optional code(error struct is free!!)',
 *         'file' => __FILE__,
 *         'line' => __LINE__,
 *         ));
 * }
 * </code>
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @subpackage Utility
 * @since 1.1
 */
class PokoXError
{

	/**
	 * 顼å
	 *
	 * @access public
	 * @since 1.1
	 * @var array
	 */
	var $errors;

	/**
	 * Singltonǥѥ󥤥󥿡ե
	 *
	 * @return PokoXError Singleton󥹥
	 * @access public
	 * @since 1.1
	 */
	function &getInstance()
	{
		static $instance = null;
		if(is_null($instance)) {
			$instance = new PokoXError();
		}
		return $instance;
	}

	/**
	 * 顼򥨥顼åpush롣
	 *
	 * @param array 顼Ϣʥե꡼եޥåȡ
	 * @return integer pushΥå
	 * @access public
	 * @since 1.1
	 */
	function raise($error_struct)
	{
		$error =& PokoXError::getInstance();
		if(!is_array($error->errors)) {
			$error->errors = array();
		}
		array_push($error->errors, $error_struct);
		return count($error->errors);
	}

	/**
	 * ߤΥ顼å֤
	 *
	 * @return integer ߤΥ顼å
	 * @access public
	 * @since 1.1
	 */
	function count()
	{
		$error =& PokoXError::getInstance();
		return count($error->errors);
	}

	/**
	 * Ǹpush줿顼Ф(pop()̾)
	 *
	 * @return array Ǹpush줿顼
	 * @access public
	 * @since 1.1
	 */
	function last()
	{
		return PokoXError::pop();
	}

	/**
	 * Ǹpush줿顼Ф
	 *
	 * @return array Ǹpush줿顼
	 * @access public
	 * @since 1.1
	 */
	function pop()
	{
		$error =& PokoXError::getInstance();
		return array_pop($error->errors);
	}

	/**
	 * 顼å򥯥ꥢ롣
	 *
	 * @return integer ꥢľΥå
	 * @access public
	 * @since 1.1
	 */
	function clear()
	{
		$error =& PokoXError::getInstance();
		$return = count($error->errors);
		$error->errors = null;
		$error->errors = array();
		return $return;
	}

	/**
	 * 顼å֤åϥꥢʤ
	 *
	 * @return array 顼å顼
	 * @access public
	 * @since 1.1
	 */
	function all()
	{
		$error =& PokoXError::getInstance();
		return $error->errors;
	}
}
?>