/*----------------------------------------------------------------------------------------------
Copyright (c) 2004, Noboru Iwata
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the <ORGANIZATION> nor the names of its contributors 
      may be used to endorse or promote products derived from this software without 
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	program    :  pmxfilter

---------------------------------------------------------------------------------------------*/
#include	<stdio.h>
#include	<stdlib.h>
#include	<memory.h>
#include	<time.h>
#include	<syslog.h>
#include	<unistd.h>
#include	"pmxfilter.h"

#define		DEBUG

#define		BUF_SIZE		256

char	SMTP_HOST[BUF_SIZE] = "";
char	MAIL_ADDR[BUF_SIZE] = "";
char	MAIL_FROM[BUF_SIZE] = "";
char	MAIL_SUBJ[BUF_SIZE] = "";
char	SEND_FLAG[BUF_SIZE] = "";

BOOL	IpSend(void);
void	DateGet(void);
void	IniRead(char *fname);
void	IniDefaultSet(void);
BOOL	StdOutPut(void);
BOOL	StdOutPut2(void);

char	LineBuf[1024];
char	TimeBuf[1024];
char	ReadBuf[1024];

int		main(int argc,char *argv[])
{
	if (argc != 2){
		syslog(LOG_NOTICE,"Ini File Misitei\n");
		IniDefaultSet();						// DEFAULT
	}
	else{
		IniRead(argv[1]);
	}
	if (strlen(SMTP_HOST) > 0 && strlen(MAIL_ADDR) > 0 && strlen(MAIL_FROM) > 0 && strlen(MAIL_SUBJ)){
		switch(SEND_FLAG[0]){
			case '0':						// SMTP SEND
				IpSend();
				break;
			case '1':						// STDOUT OUTPUT
				StdOutPut();
				break;
			case '2':						// STDOUT OUTPUT
				StdOutPut2();
				break;
		}
	}
	else{
		syslog(LOG_NOTICE,"Ini File Read Fail\n");
	}
	return(0);
}

int		IpSend(void)
{
	BOOL	rc;
	int		rcvLen;
	int		scnt;
	int		l;
	int		i;

#ifdef	DEBUG
syslog(LOG_DEBUG,"IpSend Start\n");
#endif
	rc = sub_SocInit(SMTP_HOST,25);
	if (rc == FALSE)
		return(rc);
	scnt = 0;
	while(1){
		memset(rcvMsg,0,MSGLEN);
		rcvLen = sub_cRecv(60);
		if (rcvLen > 0){
			if (memcmp(rcvMsg,"220",3) == 0){
				l = sub_cSend("HELO IWATA\r\n",12);
				scnt = 1;
			}
			else if (memcmp(rcvMsg,"250",3) == 0){
				switch(scnt){
					case 1:
						l = sub_cSend("MAIL FROM:",10);
						l = sub_cSend(MAIL_FROM,strlen(MAIL_FROM));
						l = sub_cSend("\r\n",2);
						scnt = 2;
						break;
					case 2:
						l = sub_cSend("RCPT TO:",8);
						l = sub_cSend(MAIL_ADDR,strlen(MAIL_ADDR));
						l = sub_cSend("\r\n",2);
						scnt = 3;
						break;
					case 3:
						l = sub_cSend("DATA\r\n",6);
						scnt = 4;
						break;
					case 4:
						l = sub_cSend("QUIT\r\n",6);
						scnt = 9;
						break;
				}
			}
			else if (memcmp(rcvMsg,"354",3) == 0){
				l = sub_cSend("Date: ",6);
				DateGet();
				l = sub_cSend(TimeBuf,strlen(TimeBuf));
				l = sub_cSend("\r\n",2);
				l = sub_cSend("From: ",6);
				l = sub_cSend(MAIL_FROM,strlen(MAIL_FROM));
				l = sub_cSend("\r\n",2);
				l = sub_cSend("Subject: ",9);
				l = sub_cSend(MAIL_SUBJ,strlen(MAIL_SUBJ));
				l = sub_cSend("\r\n",2);
				l = sub_cSend("To: ",4);
				l = sub_cSend(MAIL_ADDR,strlen(MAIL_ADDR));
				l = sub_cSend("\r\n",2);
				l = sub_cSend("\r\n",2);
				while(1){
					memset(LineBuf,0,sizeof(LineBuf));
					if (fgets(LineBuf,sizeof(LineBuf),stdin) == NULL){
						break;
					}
					for (i = 0;i < strlen(LineBuf);i++){
						if (LineBuf[i] == 0x0d || LineBuf[i] == 0x0a){
							LineBuf[i] = 0;
							break;
						}
					}
					if (strlen(LineBuf) < 1)
						break;
					l = sub_cSend(LineBuf,strlen(LineBuf));
					l = sub_cSend("\r\n",2);
				}
				l = sub_cSend("\r\n.\r\n",5);
			}
		}
		if (scnt == 9)
			break;
	}
	sub_SocEnd();
	return(TRUE);
}

int		StdOutPut(void)
{
	BOOL	rc;
	int		rcvLen;
	int		scnt;
	int		l;
	int		i;

#ifdef	DEBUG
syslog(LOG_DEBUG,"StdOutPut Start\n");
#endif
	scnt = 0;
	memset(LineBuf,0,sizeof(LineBuf));
	DateGet();
	sprintf(LineBuf,"Date: %s\r\n",TimeBuf);
	fputs(LineBuf,stdout);

	memset(LineBuf,0,sizeof(LineBuf));
	sprintf(LineBuf,"From: <%s>\r\n",MAIL_FROM);
	fputs(LineBuf,stdout);

	memset(LineBuf,0,sizeof(LineBuf));
	sprintf(LineBuf,"To: %s\r\n",MAIL_ADDR);
	fputs(LineBuf,stdout);

	memset(LineBuf,0,sizeof(LineBuf));
	sprintf(LineBuf,"Subject: %s\r\n",MAIL_SUBJ);
	fputs(LineBuf,stdout);

	fputs("Content-Type: text/plain; charset=\"ISO-2022-JP\"\r\n",stdout);
	fputs("Content-Transfer-Encoding: 7bit\r\n",stdout);
	fputs("\r\n",stdout);
	while(1){
		memset(LineBuf,0,sizeof(LineBuf));
		if (fgets(LineBuf,sizeof(LineBuf),stdin) == NULL){
			break;
		}
		if (strlen(LineBuf) < 3)
			break;
		fputs(LineBuf,stdout);
	}
	return(TRUE);
}

int		StdOutPut2(void)
{
	BOOL	rc;
	BOOL	flg;
	BOOL	flg2;
	int		bflg;
	int		cflg;
	char	*p;
	char	*p1;
	char	*p2;
	char	b[128];

#ifdef	DEBUG
syslog(LOG_DEBUG,"StdOutPut2 Start\n");
#endif
	rc = FALSE;
	flg = TRUE;
	flg2 = TRUE;
	bflg = 0;
	cflg = 0;
	while(1){
		memset(LineBuf,0,sizeof(LineBuf));
		if (fgets(LineBuf,sizeof(LineBuf),stdin) == NULL){
			break;
		}
		if (rc == FALSE){
			switch(bflg){
				case 0:
					p = strstr(LineBuf,"Content-Type: multipart/");
					if (p != NULL){
						p1 = strstr(p,"boundary");
						if (p1 != NULL){
							p1 = strstr(p1,"\"");
							p2 = strstr(p1+1,"\"");
							if (p1 != NULL && p2 != NULL){
								memset(b,0,sizeof(b));
								memcpy(b,p1+1,p2-p1-1);
								rc = TRUE;
							}
						}
						else{
							bflg = 1;
						}
					}
					break;
				case 1:
					p = strstr(LineBuf,"boundary");
					if (p != NULL){
						p1 = strstr(p,"\"");
						p2 = strstr(p1+1,"\"");
						if (p1 != NULL && p2 != NULL){
							memset(b,0,sizeof(b));
							memcpy(b,p1+1,p2-p1-1);
							rc = TRUE;
							bflg = 0;
						}
					}
					break;
			}
		}
		else{
			switch(cflg){
				case 0:
					p = strstr(LineBuf,b);
					if (p != NULL){
						flg = TRUE;
						cflg = 1;
					}
					break;
				case 1:
					p = strstr(LineBuf,"Content-Type:");
					if (p != NULL){
						cflg = 0;
						p1 = strstr(p,"text/plain");
						if (p1 == NULL){
							flg = FALSE;
							flg2 = TRUE;
						}
						else{
							flg = TRUE;
						}
					}
					break;
			}
		}
		if (flg == TRUE){
			fputs(LineBuf,stdout);
		}
		else{
			if (flg2 == TRUE){
				if (strlen(LineBuf) <= 2){
					flg2 = FALSE;
					fputs(LineBuf,stdout);
				}
				else{
					fputs(LineBuf,stdout);
				}
			}
		}
	}
	return(TRUE);
}

void DateGet(void)
{
	int		i;
	int		j;
	int		k;
	time_t	t;
	char	*c;
	struct	tm	*tm;
	

	t = time(&t);
	tm = localtime(&t);
	c = asctime(tm);
	memset(TimeBuf,0,sizeof(TimeBuf));
	sprintf(TimeBuf,"XXX, %2.2d XXX %4.4d %2.2d:%2.2d:%2.2d +0900",
			tm->tm_mday,tm->tm_year+1900,tm->tm_hour,tm->tm_min,tm->tm_sec);
	memcpy(TimeBuf,c,3);
	memcpy(&TimeBuf[8],(c+4),3);
	return;
}

void IniRead(char *fname)
{
	FILE	*f;
	char	*c;
	int		i,j;

	memset(SMTP_HOST,0,BUF_SIZE);
	memset(MAIL_ADDR,0,BUF_SIZE);
	memset(MAIL_FROM,0,BUF_SIZE);
	memset(MAIL_SUBJ,0,BUF_SIZE);
	f = fopen(fname,"r");
	if (f != NULL){
		while(1){
			memset(ReadBuf,0,sizeof(ReadBuf));
			c = fgets(ReadBuf,1024,f);
			if (c == NULL){
				break;
			}
			if (ReadBuf[0] == ';' || ReadBuf[0] == '#'){
				continue;
			}
			else if (memcmp(ReadBuf,"SMTP_HOST=",10) == 0){
				i = 10;
				j = 0;
				while(1){
					if (ReadBuf[i] <= 0x20)
						break;
					SMTP_HOST[j] = ReadBuf[i];
					i++;
					j++;
				}
			}
			else if (memcmp(ReadBuf,"MAIL_ADDR=",10) == 0){
				i = 10;
				j = 0;
				while(1){
					if (ReadBuf[i] <= 0x20)
						break;
					MAIL_ADDR[j] = ReadBuf[i];
					i++;
					j++;
				}
			}
			else if (memcmp(ReadBuf,"MAIL_FROM=",10) == 0){
				i = 10;
				j = 0;
				while(1){
					if (ReadBuf[i] <= 0x20)
						break;
					MAIL_FROM[j] = ReadBuf[i];
					i++;
					j++;
				}
			}
			else if (memcmp(ReadBuf,"MAIL_SUBJ=",10) == 0){
				i = 10;
				j = 0;
				while(1){
					if (ReadBuf[i] < 0x20)
						break;
					MAIL_SUBJ[j] = ReadBuf[i];
					i++;
					j++;
				}
			}
			else if (memcmp(ReadBuf,"SEND_FLAG=",10) == 0){
				i = 10;
				j = 0;
				while(1){
					if (ReadBuf[i] < 0x20)
						break;
					SEND_FLAG[j] = ReadBuf[i];
					i++;
					j++;
				}
			}
		}
		fclose(f);
	}
	else{
		syslog(LOG_NOTICE,"Ini File Not Found\n");
	}
	return;
}

void	IniDefaultSet(void)
{
	gethostname(SMTP_HOST,BUF_SIZE);
	memcpy(MAIL_ADDR,"pmxfilter",9);
	memcpy(MAIL_FROM,"pmxfilter",9);
	memcpy(MAIL_SUBJ,"no title",8);
	SEND_FLAG[0] = '1';
	return;
}

