/*----------------------------------------------------------------------------------------------
Copyright (c) 2004, Noboru Iwata
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the <ORGANIZATION> nor the names of its contributors 
      may be used to endorse or promote products derived from this software without 
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	program    :  pmxfilter

---------------------------------------------------------------------------------------------*/
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<stdio.h>
#include	<string.h>
#include	<unistd.h>
#include	<errno.h>
#include	"pmxfilter.h"

#define 	INVALID_SOCKET	  -1
#define		SOCKET_ERROR	  -1

static		short	wVerReq;
static		struct	sockaddr_in	addr;
static		struct	sockaddr_in	addrc;
static		SOCKET	s;
static		SOCKET	sc;
fd_set		Fdset_ss,Fdset_sc;		//select

static		void	ErrorHandler(char *message,DWORD err);
static		ULONG	GetHostAddress(LPSTR szBuff);

char		rcvMsg[MSGLEN];
char		sndMsg[MSGLEN];

static	ULONG	GetHostAddress(LPSTR szBuff)
{
	struct hostent	*phe;
	phe = gethostbyname(szBuff);
	if (phe == NULL)
		return(0xffffffff);
	return *((unsigned long *)phe->h_addr);
}

static	void	ErrorHandler(char *message,DWORD err)
{
	char	m[32];

	memset(m,0,sizeof(m));
	sprintf(m,"%s:[%ld]\n",message,err);
	printf(m);
}

BOOL	sub_SocInit(char *host,u_short port)
{
	int		err;
	BOOL	st;

	s = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	if (s == INVALID_SOCKET){
		ErrorHandler("SOCKET CREATE FAIL",0);
		st = FALSE;
		return(st);
	}
	memset(&addr,0x00,sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = GetHostAddress(host);
	addr.sin_port = htons(port);
	if (addr.sin_addr.s_addr == 0xffffffff){
		ErrorHandler("HOSTNAME ERROR",0);
		close(s);
		st = FALSE;
		return(st);
	}
	if (connect(s,(struct sockaddr *)&addr,sizeof(addr)) == SOCKET_ERROR){
		ErrorHandler("CONNECT FAIL",errno);
		close(s);
		st = FALSE;
		return(st);
	}
	FD_ZERO(&Fdset_sc);
	FD_SET(s,&Fdset_sc);

	st = TRUE;
	return(st);
}

void	sub_SocEnd(void)
{
	close(s);
}

int		sub_cRecv(long t)
{
	int		len;
	fd_set	Rdset;					//RCV CHECK
	struct	timeval	tv;

	Rdset = Fdset_sc;				//SOCKET
	tv.tv_sec = t;					//TIMEOUT (SE)
	tv.tv_usec = 0;
	if (select(FD_SETSIZE,&Rdset,NULL,NULL,&tv) <= 0) {
		ErrorHandler("RCV TIMEOUT",0);
		close(sc);
		return(-2);
	}

	memset(rcvMsg,0,sizeof(rcvMsg));
	len = recv(s,rcvMsg,sizeof(rcvMsg),0);
	if (len == 0){
		ErrorHandler("SOCKET CLOSE",errno);
		close(s);
		return(0);
	}
	else if(len == SOCKET_ERROR){
		ErrorHandler("RCV ERROR C",errno);
		close(s);
		return(-1);
	}
	return(len);
}

int		sub_cSend(const char *str,int len)
{
	memcpy(sndMsg,str,len);
	int slen = send(s,sndMsg,len,0);
	if (slen == SOCKET_ERROR){
		close(s);
		ErrorHandler("SEND ERROR C",errno);
		return(-1);
	}
	return(slen);
}

