/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.err;

import java.util.List;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.err.ErrorMessageItem;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;

public class DefaultErrorMessageManager
implements ErrorMessageManagerIF {
    public static final DefaultErrorMessageManager MANAGER = new DefaultErrorMessageManager();

    public String createErrorMessage(ErrorMessageStocker errorMessageStocker) {
        StringBuilder sb = new StringBuilder();
        List<ErrorMessageItem> list = errorMessageStocker.getErrorMessageList();
        for (ErrorMessageItem item : list) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            if (item.getFieldName() != null && item.getFieldName().length() > 0) {
                sb.append(HtmlTools.webStringWithSpace(item.getFieldName()));
                sb.append(HtmlTools.webStringWithSpace(" \uff1a "));
            }
            if (item.getPirkaMessage() == null) {
                sb.append(HtmlTools.webStringWithSpace(item.getMessage()));
                continue;
            }
            String code = item.getPirkaMessage().getErrorCode();
            String message = item.getPirkaMessage().getErrorMessage();
            if (code == null || code.length() <= 0) {
                sb.append(HtmlTools.webStringWithSpace(message));
                continue;
            }
            sb.append(HtmlTools.webStringWithSpace(code));
            sb.append(HtmlTools.webStringWithSpace(" "));
            sb.append(HtmlTools.webStringWithSpace(message));
        }
        return sb.toString();
    }

    public boolean isWebSafeErrorMessage() {
        return false;
    }

    public String getNgStyle() {
        return "background-color: #ff8080";
    }

    public String getNgLabelStyle() {
        return "color: #ff8080";
    }
}

