package jp.oarts.pirka.test.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.check.PirkaCheckerLength;
import jp.oarts.pirka.core.util.check.PirkaCheckerString;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringChars;
import jp.oarts.pirka.core.util.format.DateFieldFormat;
import jp.oarts.pirka.core.util.format.DateTimeFieldFormat;
import jp.oarts.pirka.core.util.format.NumericFieldFormat;
import jp.oarts.pirka.core.util.format.TimeFieldFormat;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest10 extends PirkaWindow {

	public CtrlTest10() {
		FieldMap field = getFieldMap();
		field.setOfficialFieldName("suuryou", "");
		field.setOfficialFieldName("tanka", "P");
		field.setOfficialFieldName("date", "t");
		field.setOfficialFieldName("time", "");
		field.setOfficialFieldName("datetime", "tE");

		field.setAutoCheck("returnButton", false);

		addCheck("suuryou", PirkaChecker.numeric);
		addCheck("tanka", PirkaChecker.numeric);
		addCheck("date", PirkaChecker.date);
		addCheck("time", PirkaChecker.time);
		addCheck("datetime", PirkaChecker.datetime);
		addErrorCheckReturner();

		field.setFormat("suuryou", new NumericFieldFormat("#,##0.00"));
		field.setFormat("tanka", new NumericFieldFormat("@#,##0.00"));
		field.setFormat("kingaku", new NumericFieldFormat("\\#,##0"));

		field.setFormat("date", new DateFieldFormat("yyyy/MM/dd"));
		field.setFormat("date1", new DateFieldFormat("yyyy/M/d"));
		field.setFormat("date2", new DateFieldFormat("yyyyNMMdd"));

		field.setFormat("time", new TimeFieldFormat("HH:mm:ss"));
		field.setFormat("time1", new TimeFieldFormat("H:m:s"));
		field.setFormat("time2", new TimeFieldFormat("HHmmssb"));

		field.setFormat("datetime", new DateTimeFieldFormat("yyyy/MM/dd HH:mm:ss"));
		field.setFormat("datetime1", new DateTimeFieldFormat("yyyy/M/d H:m:s"));
		field.setFormat("datetime2", new DateTimeFieldFormat("yyyyNMMdd HHmmssb"));

		field.setFormat("label_1", field.getFormat("suuryou"));
		field.setFormat("label_2", field.getFormat("tanka"));
	}

	public void execButton() {
		FieldMap field = getFieldMap();

		BigDecimal suuryou = field.getValueBigDecimal("suuryou");
		BigDecimal tanka = field.getValueBigDecimal("tanka");
		if (suuryou != null && tanka != null) {
			field.setValue("kingaku", suuryou.multiply(tanka));
		} else {
			field.setValue("kingaku", "");
		}

		field.setValue("date1", field.getValueDate("date"));
		field.setValue("date2", field.getValueDate("date"));
		field.setValue("time1", field.getValueTime("time"));
		field.setValue("time2", field.getValueTime("time"));
		field.setValue("datetime1", field.getValueTimestamp("datetime"));
		field.setValue("datetime2", field.getValueTimestamp("datetime"));

		field.setValue("label_1", field.getValueBigDecimal("suuryou"));
		field.setValue("label_2", field.getValueBigDecimal("tanka"));
	}

	public PirkaWindow returnButton() {
		return null;
	}
}
