package jp.oarts.pirka.sample.instruction.is103500;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * pirkatTv DTO(Map)gpʓo͕@
 */
public class DtoSample extends PirkaWindow {

	//	f[^p^[1
	Map<String, Object> data01;

	//	f[^p^[2
	Map<String, Object> data02;

	/**
	 * RXgN^
	 */
	public DtoSample() {

		//	f[^p^[1̍쐬
		data01 = new HashMap<String, Object>();
		data01.put("textareaItem", "f[^p^[1");
		data01.put("textItem", "");
		data01.put("passwordItem", "abc");
		data01.put("radioItem", "R01");
		data01.put("checkboxItem", false);
		data01.put("selectItem", "A");
		List<Map<String, Object>> loop01 = new ArrayList<Map<String, Object>>();
		data01.put("loop", loop01);
		for (int i = 0; i < 2; i++) {
			HashMap<String, Object> data = new HashMap<String, Object>();
			data.put("loopNo", i + 1);
			data.put("loopnName", "p^[01" + (i + 1));
			data.put("loopnSelect", false);
			loop01.add(data);
		}

		//	f[^p^[2̍쐬
		data02 = new HashMap<String, Object>();
		data02.put("textareaItem", "f[^p^[2");
		data02.put("textItem", "Ă");
		data02.put("passwordItem", "vwxyz");
		data02.put("radioItem", "R02");
		data02.put("checkboxItem", true);
		data02.put("selectItem", "B");
		List<Map<String, Object>> loop02 = new ArrayList<Map<String, Object>>();
		data02.put("loop", loop02);
		for (int i = 0; i < 4; i++) {
			HashMap<String, Object> data = new HashMap<String, Object>();
			data.put("loopNo", i + 1);
			data.put("loopnName", "p^[02" + (i + 1));
			data.put("loopnSelect", true);
			loop02.add(data);
		}
	}

	/**
	 * setDtogpf[^p^[1̏lݒ{^
	 */
	public void set01Button() {
		// f[^p^[1ʂɐݒ
		setDto(data01);
	}

	/**
	 * setDtogpf[^p^[2̏lݒ{^
	 */
	public void set02Button() {
		// f[^p^[2ʂɐݒ
		setDto(data02);
	}

	/**
	 * getDtogpf[^̎擾{^
	 */
	public void getButton() {

		// ʂ̃f[^MapɎ擾
		Map<String, Object> dto = getDto();

		// 擾f[^\
		FieldMap field = getFieldMap();
		field.setValue("message", toString(dto));
	}

	private String toString(Map<String, Object> dto) {

		StringBuilder sb = new StringBuilder();
		sb.append("textareaItem=");
		sb.append(dto.get("textareaItem"));
		sb.append("\n");
		sb.append("textItem=");
		sb.append(dto.get("textItem"));
		sb.append("\n");
		sb.append("passwordItem=");
		sb.append(dto.get("passwordItem"));
		sb.append("\n");
		sb.append("radioItem=");
		sb.append(dto.get("radioItem"));
		sb.append("\n");
		sb.append("checkboxItem=");
		sb.append(dto.get("checkboxItem"));
		sb.append("\n");
		sb.append("selectItem=");
		sb.append(dto.get("selectItem"));
		sb.append("\n");

		List<Map<String, Object>> loop = (List<Map<String, Object>>) dto.get("loop");
		for (Map<String, Object> loopDto : loop) {
			sb.append("loopNo=");
			sb.append(loopDto.get("loopNo"));
			sb.append(", ");
			sb.append("loopnName=");
			sb.append(loopDto.get("loopnName"));
			sb.append(", ");
			sb.append("loopnSelect=");
			sb.append(loopDto.get("loopnSelect"));
			sb.append("\n");
		}
		return sb.toString();
	}

	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

}
