/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.analyzer.cls.ClassAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlFieldMapAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlIncludeAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlMockupAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlSplitAnalyzer;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirkaInfoPool
implements Serializable {
    private static final HashMap<String, List<HtmlParts>> htmlPool = new HashMap();
    private static final HashMap<String, Map<String, FieldMap>> fieldPool = new HashMap();
    private static final HashMap<String, Map<String, Method>> methodMap = new HashMap();

    public static synchronized List<HtmlParts> getHtmlPartsList(String htmlFileName) {
        List<HtmlParts> htmlPartsList = null;
        if (!htmlPool.containsKey(htmlFileName)) {
            StringReader sr = null;
            try {
                try {
                    String html = HtmlIncludeAnalyzer.include(htmlFileName);
                    sr = new StringReader(html);
                    htmlPartsList = HtmlSplitAnalyzer.getHtmlParts(sr);
                    htmlPartsList = HtmlMockupAnalyzer.cutMockup(htmlPartsList);
                }
                catch (IOException iOException) {}
            }
            finally {
                if (sr != null) {
                    sr.close();
                }
            }
            htmlPool.put(htmlFileName, htmlPartsList);
        } else {
            htmlPartsList = htmlPool.get(htmlFileName);
        }
        return htmlPartsList;
    }

    public static synchronized FieldMap getFieldMap(String htmlFileName) {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        String entryPointClassName = entryPoint.getClass().getName();
        Map<String, FieldMap> entryPointClassMap = fieldPool.get(entryPointClassName);
        if (entryPointClassMap == null) {
            entryPointClassMap = new HashMap<String, FieldMap>();
            fieldPool.put(entryPointClassName, entryPointClassMap);
        }
        FieldMap fieldMap = null;
        if (!entryPointClassMap.containsKey(htmlFileName)) {
            List<HtmlParts> htmlPartsList = PirkaInfoPool.getHtmlPartsList(htmlFileName);
            fieldMap = HtmlFieldMapAnalyzer.getFieldMap(htmlPartsList, entryPoint.getCtrlProcesserMap());
            entryPointClassMap.put(htmlFileName, fieldMap);
        } else {
            fieldMap = entryPointClassMap.get(htmlFileName);
        }
        return fieldMap;
    }

    public static synchronized Method getMethod(Object object, String name) {
        return PirkaInfoPool.getMethodMap(object).get(name);
    }

    private static Map<String, Method> getMethodMap(Object object) {
        Map<String, Method> rtnMap = null;
        String className = object.getClass().getName();
        if (!methodMap.containsKey(className)) {
            rtnMap = ClassAnalyzer.getMethodMap(object);
            methodMap.put(className, rtnMap);
        } else {
            rtnMap = methodMap.get(className);
        }
        return rtnMap;
    }
}

