package jp.oarts.pirka.core.util.check;

import java.io.Serializable;

import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

public class PirkaChecker implements Serializable {

	/** 쐬ς݃`FbJ[FK{̓`FbN */
	public static final Checker required = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value == null || value.length() <= 0) {
				throw new PirkaCheckException("͂ł");
			}
		}
	};

	/** 쐬ς݃`FbJ[Fl͂ĂintlƂĕϊ\ȕł邱 */
	public static final Checker intValue = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value.length() > 0) {
				if (PirkaFormatUtil.parseInteger(value) == null) {
					throw new PirkaCheckException("͂ꂽl͐lȊO͌I[o[ł");
				}
			}
		}
	};

	/** 쐬ς݃`FbJ[Fl͂ĂlonglƂĕϊ\ȕł邱 */
	public static final Checker longValue = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value.length() > 0) {
				if (PirkaFormatUtil.parseLong(value) == null) {
					throw new PirkaCheckException("͂ꂽl͐lȊO͌I[o[ł");
				}
			}
		}
	};

	/** 쐬ς݃`FbJ[Fl͂ĂBigDecimallƂĕϊ\ȕł邱 */
	public static final Checker numeric = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value.length() > 0) {
				if (PirkaFormatUtil.parseBigDecimal(value) == null) {
					throw new PirkaCheckException("͂ꂽl͐lł͂܂");
				}
			}
		}
	};

	/** 쐬ς݃`FbJ[Ft͂ĂtƂĕϊ\ȕł邱 */
	public static final Checker date = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value.length() > 0) {
				if (PirkaFormatUtil.parseDate(value) == null) {
					throw new PirkaCheckException("͂ꂽt̏ɂ܂肪܂");
				}
			}
		}
	};

	/** 쐬ς݃`FbJ[F͂Ă玞Ƃĕϊ\ȕł邱 */
	public static final Checker time = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value.length() > 0) {
				if (PirkaFormatUtil.parseTime(value) == null) {
					throw new PirkaCheckException("͂ꂽ̏ɂ܂肪܂");
				}
			}
		}
	};

	/** 쐬ς݃`FbJ[Ft͂ĂtƂĕϊ\ȕł邱 */
	public static final Checker datetime = new Checker() {
		public void check(String value) throws PirkaCheckException {
			if (value.length() > 0) {
				if (PirkaFormatUtil.parseTimestamp(value) == null) {
					throw new PirkaCheckException("͂ꂽt̏ɂ܂肪܂");
				}
			}
		}
	};

	// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * \`FbN
	 * 
	 * @param string
	 *            `FbNsȂ
	 * @param existStrings
	 *            \i[Ă镶
	 * @throws PirkaCheckException
	 *             G[
	 * @return true=\ō\Ă
	 */
	public static boolean checkString(String string, String... existStrings) {
		int length = string.length();
		for (int i = 0; i < length; i++) {
			char c = string.charAt(i);
			boolean flg = false;
			for (String existString : existStrings) {
				if (existString.indexOf(c) >= 0) {
					flg = true;
					break;
				}
			}
			if (!flg) {
				return false;
			}
		}
		return true;
	}

	/**
	 * \`FbN
	 * 
	 * @param string
	 *            `FbNsȂ
	 * @return true=̂
	 */
	public static boolean isNumber(String string) {
		return checkString(string, "0123456789");
	}

}
