package jp.oarts.pirka.core.general;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * HTMLp[c
 * 
 * @author ito
 * 
 */
public class HtmlParts  implements Serializable{

	/** HTMLp[c̎ */
	private HtmlPartsType type;

	/** ^OKw̐[ root=0 */
	private int deep;

	/** HTMLt@Cł̃IWi̕ */
	private String orgString;

	/** ^O */
	private String tagName;

	/** O */
	private String name;

	/** I^ÕIWi */
	private String endTagOrgString;

	/** }bv */
	private TreeMap<String, String> option;

//	/** I^Ȏ}bv */
//	private TreeMap<String, String> endTagOption;

	/** ^ÓiJn^OI^Oɋ܂ꂽjHTMLi */
	private List<HtmlParts> child;

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() {
		HtmlParts cloneObject = new HtmlParts();
		cloneObject.type = type;
		cloneObject.deep = deep;
		cloneObject.orgString = orgString;
		cloneObject.tagName = tagName;
		cloneObject.name = name;
		cloneObject.endTagOrgString = endTagOrgString;

		if (option != null) {
			cloneObject.option = new TreeMap<String, String>();
			cloneObject.option.putAll(option);
		} else {
			cloneObject.option = null;

		}

//		if (endTagOption != null) {
//			cloneObject.endTagOption = new TreeMap<String, String>();
//			cloneObject.endTagOption.putAll(endTagOption);
//		} else {
//			cloneObject.endTagOption = null;
//		}

		if (child == null) {
			cloneObject.child = null;
		} else {
			cloneObject.child = new ArrayList<HtmlParts>();
			for (HtmlParts parts : child) {
				cloneObject.child.add((HtmlParts) parts.clone());
			}
		}

		return cloneObject;
	}

	/**
	 * @return deep ߂܂B
	 */
	public int getDeep() {
		return deep;
	}

	/**
	 * @param deep
	 *            ݒ肷 deepB
	 */
	public void setDeep(int deep) {
		this.deep = deep;
	}

	/**
	 * @return endTag ߂܂B
	 */
	public String getEndTag() {
		return endTagOrgString;
	}

	/**
	 * @param endTag
	 *            ݒ肷 endTagB
	 */
	public void setEndTag(String endTag) {
		this.endTagOrgString = endTag;
	}

	/**
	 * @return name ߂܂B
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            ݒ肷 nameB
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return option ߂܂B
	 */
	public TreeMap<String, String> getOption() {
		return option;
	}

	/**
	 * @param option
	 *            ݒ肷 optionB
	 */
	public void setOption(TreeMap<String, String> option) {
		this.option = option;
	}

	/**
	 * @return orgString ߂܂B
	 */
	public String getOrgString() {
		return orgString;
	}

	/**
	 * @param orgString
	 *            ݒ肷 orgStringB
	 */
	public void setOrgString(String orgString) {
		this.orgString = orgString;
	}

	/**
	 * @return tagName ߂܂B
	 */
	public String getTagName() {
		return tagName;
	}

	/**
	 * @param tagName
	 *            ݒ肷 tagNameB
	 */
	public void setTagName(String tagName) {
		this.tagName = tagName;
	}

	/**
	 * @return type ߂܂B
	 */
	public HtmlPartsType getType() {
		return type;
	}

	/**
	 * @param type
	 *            ݒ肷 typeB
	 */
	public void setType(HtmlPartsType type) {
		this.type = type;
	}

	public String toString() {
		return toString("");
	}

	public String toString(String leftMrg) {

		StringBuilder sb = new StringBuilder();

		sb.append(leftMrg);

		sb.append("type=" + type.toString());
		sb.append(", ");

		sb.append("deep=" + deep);
		sb.append(", ");

		sb.append("tagName=" + tagName);
		sb.append(", ");

		sb.append("name=" + name);
		sb.append(", ");

		sb.append("endTag=" + endTagOrgString);
		sb.append(", ");

		sb.append("option:");
		if (option == null) {
			sb.append("null");
		} else {
			boolean first = true;
			for (String key : option.keySet()) {
				if (!first) {
					sb.append(", ");
				}
				first = false;
				String value = option.get(key);
				if (value.length() <= 0) {
					sb.append(key);
				} else {
					sb.append(key);
					sb.append("=");
					sb.append(value);
				}
			}
		}
		sb.append(", ");

		sb.append("orgString=" + orgString.replace('\n', '.').replace('\r', '.'));

		if (child != null) {
			sb.append("\n");
			leftMrg = leftMrg + "  ";
			for (HtmlParts part : child) {
				sb.append(part.toString(leftMrg));
				sb.append("\n");
			}
		}
		return sb.toString();
	}

	/**
	 * @return child ߂܂B
	 */
	public List<HtmlParts> getChild() {
		return child;
	}

	/**
	 * @param child
	 *            ݒ肷 childB
	 */
	public void setChild(List<HtmlParts> child) {
		this.child = child;
	}

//	/**
//	 * @return endTagOption ߂܂B
//	 */
//	public TreeMap<String, String> getEndTagOption() {
//		return endTagOption;
//	}
//
//	/**
//	 * @param endTagOption
//	 *            ݒ肷 endTagOptionB
//	 */
//	public void setEndTagOption(TreeMap<String, String> endTagOption) {
//		this.endTagOption = endTagOption;
//	}
}
