package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * INPUT#Checkbox^OvZbT[
 * 
 * @author ito
 * 
 */
public class InputCheckboxProcesser extends CtrlProcesser {

	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ
	 * 
	 * @return true=qp[c̃^O
	 */
	@Override
	public boolean isUseChild() {
		return false;
	}

	/**
	 * [v^O̎tureԂ
	 * 
	 * @return true=[v^O
	 */
	@Override
	public boolean isLoop() {
		return false;
	}

	/**
	 * XCb`^O̎tureԂ
	 * 
	 * @return true=XCb`^O
	 */
	public boolean isSwitch() {
		return false;
	}

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ
	 * 
	 * @return true=uEUœ
	 */
	@Override
	public boolean isInputCtrl() {
		return true;
	}

	/**
	 * uEU[̃ANVƂtureԂ
	 * 
	 * @return true=ANV
	 */
	@Override
	public boolean isActionCtrl() {
		return false;
	}

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ
	 * 
	 * @return true=O[sOvf
	 */
	public boolean isGroupItem() {
		return false;
	}

	/**
	 * `FbNsȂRg[̎tureԂ
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public boolean isCheckCtrl() {
		return true;
	}

	/**
	 * tH[}bg\ȃRg[̎tureԂ
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public boolean isFormatCtrl() {
		return false;
	}

	/**
	 * f[^̃ZbgsȂ
	 * 
	 * @param data
	 */
	public void setValue(Object data, FieldItem fieldItem) {
		// throw new RuntimeException("̃\bh͎gpł܂ setChecked\bhgpĂ");
		if (data == null || !(data instanceof Boolean)) {
			throw new RuntimeException("w肳ꂽl̓Zbgł܂ booleanlBoolenIuWFNgZbgĂ");
		}
		fieldItem.setChecked((Boolean) data);
	}

	/**
	 * l͂
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	@Override
	public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
	}

	/**
	 * ^O쐬
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @return 쐬ꂽ^O
	 */
	public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, //
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag) {

		Map<String, String> optionMap = ctrl.getOptionMap();
		if (errorFlag) {
			optionMap = changeStyle(errorMessageManager.getNgStyle(), optionMap);
		}

		StringBuilder sb = new StringBuilder();

		sb.append('<');
		sb.append(ctrl.getTagName());
		sb.append(createOptionStringChecked(ctrl.getTypeOption(), ctrl.getBaseName() + loopSuffix, loopSuffix, "on", ctrl.isSuffix(), optionMap, checked));
		sb.append(">");
		sb.append("<input type=\"hidden\" name=\"$$" + ctrl.getBaseName() + loopSuffix + "\" value=\"exists\">");
		return sb.toString();
	}

	/**
	 * NGXgi͌ʁjtB[hɃZbg
	 * 
	 * @param reqMap
	 *            NGXg}bv
	 * @param fieldName
	 *            TtBbNXttB[h
	 * @param fieldItem
	 *            tB[h
	 * @param values
	 *            l
	 */
	@Override
	public void setReq(Map<String, String[]> reqMap, String fieldName, FieldItem fieldItem, String[] values) {

		if (reqMap.containsKey("$$" + fieldName)) {
			if (values != null && values.length > 0 && values[0] != null) {
				fieldItem.setChecked(true);
				fieldItem.setValue(true);
			} else {
				fieldItem.setChecked(false);
				fieldItem.setValue(false);
			}
		}
	}

}
