package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.app.EntryPoint;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * FORM^OvZbT[
 * 
 * @author ito
 * 
 */
public class FormProcesser extends CtrlProcesser {

	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ
	 * 
	 * @return true=qp[c̃^O
	 */
	@Override
	public boolean isUseChild() {
		return false;
	}

	/**
	 * [v^O̎tureԂ
	 * 
	 * @return true=[v^O
	 */
	@Override
	public boolean isLoop() {
		return false;
	}

	/**
	 * XCb`^O̎tureԂ
	 * 
	 * @return true=XCb`^O
	 */
	public boolean isSwitch() {
		return false;
	}

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ
	 * 
	 * @return true=uEUœ
	 */
	@Override
	public boolean isInputCtrl() {
		return false;
	}

	/**
	 * uEU[̃ANVƂtureԂ
	 * 
	 * @return true=ANV
	 */
	@Override
	public boolean isActionCtrl() {
		return false;
	}

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ
	 * 
	 * @return true=O[sOvf
	 */
	public boolean isGroupItem() {
		return false;
	}

	/**
	 * `FbNsȂRg[̎tureԂ
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public boolean isCheckCtrl() {
		return false;
	}

	/**
	 * tH[}bg\ȃRg[̎tureԂ
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public boolean isFormatCtrl() {
		return false;
	}

	/**
	 * f[^̃ZbgsȂ
	 * 
	 * @param data
	 */
	public void setValue(Object data, FieldItem fieldItem) {
		if (data == null || !(data instanceof String)) {
			throw new RuntimeException("w肳ꂽl̓Zbgł܂ StringIuWFNgZbgĂ");
		}

		fieldItem.setValue((String) data);
	}

	/**
	 * l͂
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	@Override
	public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
		if (searchInputFileTag(list)) {
			ctrl.getOptionMap().put("method", "POST");
			ctrl.getOptionMap().put("enctype", "multipart/form-data");
		}
	}

	/**
	 * CvbgEt@C^O݂邩
	 * 
	 * @param list
	 *            HTMLp[c
	 * @return true=݂
	 */
	private boolean searchInputFileTag(List<HtmlParts> list) {
		if (list != null) {
			for (HtmlParts parts : list) {
				if (parts.getType() == HtmlPartsType.TAG) {
					if (parts.getTagName().equalsIgnoreCase("input")) {
						if (parts.getOption().containsKey("type")) {
							if ("file".equalsIgnoreCase(parts.getOption().get("type")))
								return true;
						}
					}
					if (parts.getChild() != null) {
						if (searchInputFileTag(parts.getChild())) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	/**
	 * ^O쐬
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @return 쐬ꂽ^O
	 */
	public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, //
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag) {

		StringBuilder sb = new StringBuilder();

		sb.append('<');
		sb.append(ctrl.getTagName());
		sb.append(createFormOptionString(ctrl.getName() + loopSuffix, loopSuffix, ctrl.getOptionMap(), ctrl.isSuffix()));
		sb.append(">");

		// sJ}[N
		sb.append("<input type=\"hidden\" name=\"" + EntryPoint.REQ_PIRKA_MARK + "\" value=\"" + EntryPoint.REQ_FORM + "\">");
		// CX^Xԍ
		sb.append("<input type=\"hidden\" name=\"" + EntryPoint.REQ_INSTANCE + "\" value=\"" + windowBaseData.getInstanceNo() + "\">");
		// VAԍ
		sb.append("<input type=\"hidden\" name=\"" + EntryPoint.REQ_SERIALNO + "\" value=\"" + windowBaseData.getSerialNo() + "\">");

		return sb.toString();
	}

	/**
	 * }bv𕶎ɕϊ
	 * 
	 * @param optionMap
	 *            }bv
	 * @return ϊꂽ
	 */
	protected String createFormOptionString(String name, String loopSuffix, Map<String, String> optionMap, boolean isSuffix) {
		StringBuilder sb = new StringBuilder();

		if (name != null && name.length() > 0) {
			sb.append(" name=\"");
			sb.append(name);
			sb.append("\"");
		}

		sb.append(" action=\"");
		String action = optionMap.get("action");
		if (action == null || action.length() <= 0) {
			sb.append(PirkaThreadMap.getEntryPointObjct().getUrlAlias());
		} else {
			sb.append(action);
		}
		sb.append("\"");

		for (String key : optionMap.keySet()) {
			if (!key.equalsIgnoreCase("name") && !key.equalsIgnoreCase("action")) {
				addOption(sb, optionMap, key, isSuffix, loopSuffix);
			}
		}

		return sb.toString();
	}
}
