package jp.oarts.pirka.core.analyzer.html;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;

import jp.oarts.pirka.core.app.OfflineEntryPoint;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

public class HtmlToolAnalyzer  implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 55986138998965783L;

	/**
	 * HTMLt@C͂Ot̃Rg[̃}bv쐬
	 * 
	 * @param htmlFile
	 *            HTMLt@CFleIuWFNg
	 * @return Rg[}bv
	 * @throws IOException
	 */
	public static FieldMap getFieldMap(File htmlFile) throws IOException {

		FieldMap fieldMap = null;
		List<HtmlParts> htmlPartsList = null;
		StringReader sr = null;

		try {
			String html = HtmlIncludeAnalyzer.include(htmlFile);
			sr = new StringReader(html);
			htmlPartsList = HtmlSplitAnalyzer.getHtmlParts(sr);
			htmlPartsList = HtmlMockupAnalyzer.cutMockup(htmlPartsList);
			sr.close();
			sr = null;
			fieldMap = HtmlFieldMapAnalyzer.getFieldMap(htmlPartsList,  OfflineEntryPoint.getInstance().getCtrlProcesserMap());

			return fieldMap;
		} finally {
			if (sr != null) {
				sr.close();
			}
		}

	}

	/**
	 * eXgC
	 * 
	 * @param args	p[^Ƀt@CpXw肷邱
	 */
	public static void main(String[] args) {
		try {
			FieldMap fieldMap = HtmlToolAnalyzer.getFieldMap(new File(args[0]));
			print(fieldMap);

		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	/**
	 * Rg[}bv̕\
	 * 
	 * @param fieldMap
	 */
	public static void print(FieldMap fieldMap) {
		if (fieldMap == null) {
			return;
		}

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			HtmlCtrlParts ctrlParts = fieldItem.getCtrl();
			CtrlProcesser ctrlProcesser = ctrlParts.getCtrlProcesser();

			System.out.print(fieldName);
			System.out.print(" : tag=");
			System.out.print(ctrlParts.getTagName());
			System.out.print(" : type=");
			System.out.print(ctrlParts.getTypeOption());
			System.out.print(" : [vKw=");
			System.out.print(fieldItem.getLoopDeepLevel());
			System.out.print(" : =");
			System.out.print(ctrlProcesser.isInputCtrl());
			System.out.print(" : `FbN^Cv=");
			System.out.print(ctrlProcesser.isCheckCtrl());
			System.out.print(" : ANV\bh=");
			System.out.print(ctrlProcesser.isActionCtrl());
			System.out.print(" : [v=");
			System.out.print(ctrlProcesser.isLoop());
			System.out.println();

			if (ctrlProcesser.isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childMap : list) {
					print(childMap);
				}
			}
		}
	}
}
