package jp.oarts.pirka.core.analyzer.html;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;

/**
 * bNAbvpɋLqꂽ^Oyё̕ύXyэ폜sȂB
 * 
 * @author ito
 * 
 */
public class HtmlMockupAnalyzer implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8675705373946109821L;

	/** sJbNAbvp^O */
	public static final String PIRKA_MOCK_TAG_NAME = "pirka_mockup";

	/** sJbNAbvpuvtBNX */
	public static final String PIRKA_MOCK_CHANGE_OPTION_PREFIX_NAME = "pirka_change_";

	/** sJbNAbvp폜vtBNX */
	public static final String PIRKA_MOCK_DELETE_OPTION_PREFIX_NAME = "pirka_delete_";

	/**
	 * bNAbvJbg
	 * 
	 * @param list
	 * @return
	 * @throws IOException
	 */
	public static List<HtmlParts> cutMockup(List<HtmlParts> orgHtmlPartsList) throws IOException {

		// bNAbṽ^O
		List<HtmlParts> list = cutMockupTag(orgHtmlPartsList);

		// sJ
		changeMockupOption(list);

		return list;
	}

	/**
	 * bNAbv^OJbgAbNAbv^ÕRgLƂ
	 * 
	 * @param list
	 * @return
	 * @throws IOException
	 */
	private static List<HtmlParts> cutMockupTag(List<HtmlParts> orgHtmlPartsList) throws IOException {

		List<HtmlParts> inputList = HtmlTools.cloneHtmlPartsList(orgHtmlPartsList);
		List<HtmlParts> rtnList = new ArrayList<HtmlParts>();

		// sJ^OisJ^ÕRgÕRgHTMLLƂA܂AsJ^ÕRgȊÕp[c͊Oj
		for (HtmlParts parts : inputList) {
			if (parts.getType() != HtmlPartsType.TAG) {
				rtnList.add(parts);
			} else {
				if (PIRKA_MOCK_TAG_NAME.equalsIgnoreCase(parts.getTagName())) {
					if (parts.getChild() != null) {
						for (HtmlParts subParts : parts.getChild()) {
							if (subParts.getType() == HtmlPartsType.COMMENT) {
								String comment = subParts.getOrgString();
								List<HtmlParts> subList = HtmlSplitAnalyzer.getHtmlParts(comment.substring(4, comment.length() - 3));
								for (HtmlParts splitSubParts : subList) {
									rtnList.add(splitSubParts);
								}
							}
						}
					} else {
						// Ȃ
					}
				} else {
					rtnList.add(parts);
					if (parts.getChild() != null) {
						parts.setChild(cutMockupTag(parts.getChild()));
					}
				}
			}
		}

		return rtnList;
	}

	/**
	 * sJp̑ŃbNAbvp̑SĒu
	 * 
	 * @param list
	 *            HTMLp[cXg
	 */
	private static void changeMockupOption(List<HtmlParts> list) {
		for (HtmlParts parts : list) {

			if (parts.getType() == HtmlPartsType.TAG) { // ^OɂďsȂ
				// changeMockupOption(parts.getOption());
				changeMockupOption(parts);

				// qqɂĂsȂB
				if (parts.getChild() != null) {
					changeMockupOption(parts.getChild());
				}
			}

		}
	}

	/**
	 * ̕ϊ<BR>
	 * w肳ꂽ}bvsJύX̕ύXyуsJ폜̍폜sȂ
	 * 
	 * @param optionMap
	 *            }bv
	 */
	private static void changeMockupOption(HtmlParts parts) {

		Map<String, String> optionMap = parts.getOption();
		int prefixChangeLength = PIRKA_MOCK_CHANGE_OPTION_PREFIX_NAME.length();
		int prefixDeleteLength = PIRKA_MOCK_DELETE_OPTION_PREFIX_NAME.length();

		if (optionMap != null) {
			String[] keys = optionMap.keySet().toArray(new String[0]); // L[ꗗ擾

			for (String key : keys) {
				if (key.length() > prefixDeleteLength && key.substring(0, prefixDeleteLength).equalsIgnoreCase(PIRKA_MOCK_DELETE_OPTION_PREFIX_NAME)) { // vtBNX폜H
					String newKey = key.substring(prefixDeleteLength); // sJ}[N폜߂
					if ("name".equalsIgnoreCase(newKey)) {
						parts.setName(null);
					} 
					optionMap.remove(newKey); // 폜
					optionMap.remove(key); // sJ}[N폜
				} else if (key.length() > prefixChangeLength && key.substring(0, prefixChangeLength).equalsIgnoreCase(PIRKA_MOCK_CHANGE_OPTION_PREFIX_NAME)) { // vtBNXuH
					String newKey = key.substring(prefixChangeLength); // sJ}[N폜߂
					if ("name".equalsIgnoreCase(newKey)) {
						parts.setName(optionMap.get(key));
					}
					optionMap.put(newKey, optionMap.get(key)); // ̑Œlo^
					optionMap.remove(key); // sJ}[N폜
				}
			}
		}

	}

	public static void main(String[] args) {
		try {
			List<HtmlParts> list = cutMockup(HtmlSplitAnalyzer.getHtmlParts(HtmlIncludeAnalyzer.include("/jp/oarts/pirka/core/win/Test.html")));
			System.out.println(HtmlTools.toSimpleString(list));

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
