/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import jdd.des.automata.bdd.BDDAutomata;

public class ConjunctivePartitions {
    private BDDAutomata automata;
    private int count;
    private int[] delta_conj;
    private int[] s_cube;

    public ConjunctivePartitions(BDDAutomata bDDAutomata) {
        this.automata = bDDAutomata;
        this.count = bDDAutomata.automata.length;
        this.delta_conj = new int[this.count];
        this.s_cube = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.delta_conj[i] = bDDAutomata.ref(bDDAutomata.automata[i].getBDDDeltaTop());
            this.s_cube[i] = bDDAutomata.ref(bDDAutomata.automata[i].getBDDCubeS());
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.count; ++i) {
            this.automata.deref(this.delta_conj[i]);
            this.automata.deref(this.s_cube[i]);
        }
        this.count = 0;
    }

    public int getSize() {
        return this.count;
    }

    public int getBDDDeltaTop(int n) {
        return this.delta_conj[n];
    }

    public int getBDDSCube(int n) {
        return this.s_cube[n];
    }

    public BDDAutomata getBDDAutomata() {
        return this.automata;
    }
}

