/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.Arrays;
import v1.ParameterModel;
import v1.ParameterValuePair;
import v1.ParameterValuePairComparator;
import v1.QuintList;
import v1.TupleTable;

class QuintTable
extends TupleTable {
    QuintList[][][][][] table;
    ParameterModel parametermodel;

    QuintTable(ParameterModel parametermodel) {
        this.parametermodel = parametermodel;
        int n = parametermodel.size;
        this.table = new QuintList[n][n][n][n][n];
        int p0 = 0;
        while (p0 < n - 4) {
            int p1 = p0 + 1;
            while (p1 < n - 3) {
                int p2 = p1 + 1;
                while (p2 < n - 2) {
                    int p3 = p2 + 1;
                    while (p3 < n - 1) {
                        int p4 = p3 + 1;
                        while (p4 < n) {
                            assert (p0 < p1 && p1 < p2 && p2 < p3 && p3 < p4);
                            this.table[p0][p1][p2][p3][p4] = new QuintList(parametermodel.range[p0], parametermodel.range[p1], parametermodel.range[p2], parametermodel.range[p3], parametermodel.range[p4]);
                            ++p4;
                        }
                        ++p3;
                    }
                    ++p2;
                }
                ++p1;
            }
            ++p0;
        }
    }

    boolean get(int p1, byte v1, int p2, byte v2, int p3, byte v3, int p4, byte v4, int p5, byte v5) {
        ParameterValuePair[] pv = new ParameterValuePair[]{new ParameterValuePair(p1, v1), new ParameterValuePair(p2, v2), new ParameterValuePair(p3, v3), new ParameterValuePair(p4, v4), new ParameterValuePair(p5, v5)};
        Arrays.sort(pv, new ParameterValuePairComparator());
        return this.table[pv[0].p][pv[1].p][pv[2].p][pv[3].p][pv[4].p].list[this.getOffset(pv)];
    }

    void set(int p1, byte v1, int p2, byte v2, int p3, byte v3, int p4, byte v4, int p5, byte v5) {
        ParameterValuePair[] pv = new ParameterValuePair[]{new ParameterValuePair(p1, v1), new ParameterValuePair(p2, v2), new ParameterValuePair(p3, v3), new ParameterValuePair(p4, v4), new ParameterValuePair(p5, v5)};
        Arrays.sort(pv, new ParameterValuePairComparator());
        this.table[pv[0].p][pv[1].p][pv[2].p][pv[3].p][pv[4].p].list[this.getOffset((ParameterValuePair[])pv)] = true;
    }

    private int getOffset(ParameterValuePair[] pv) {
        int offset = pv[0].v;
        int i = 1;
        while (i < pv.length) {
            int width = 1;
            int j = 0;
            while (j < i) {
                width *= this.parametermodel.range[pv[j].p];
                ++j;
            }
            offset += pv[i].v * width;
            ++i;
        }
        return offset;
    }
}

