/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import jdd.graph.AttributeExplorer;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.DisjointSet;
import jdd.util.JDDConsole;

public class Partition
extends DisjointSet {
    private int root;
    private Graph graph;

    public Partition(Graph graph) {
        super(graph.numOfNodes());
        this.graph = graph;
        AttributeExplorer.updateExtraIndex(graph);
        this.root = -1;
    }

    void newPartition() {
        this.root = -1;
    }

    void addToPartition(Node node) {
        int n = node.extraindex;
        if (this.root == -1) {
            this.root = n;
        } else {
            this.union(n, this.root);
        }
        this.root = this.find(n);
    }

    public boolean inSamePartition(Node node, Node node2) {
        return this.find(node.extraindex) == this.find(node2.extraindex);
    }

    public void show() {
        for (int i = 0; i < this.size; ++i) {
            if (this.s[i] >= 0) continue;
            JDDConsole.out.print(" (");
            for (int j = 0; j < this.size; ++j) {
                if (this.find(j) != i) continue;
                Node node = (Node)this.graph.getNodes().elementAt(j);
                JDDConsole.out.print(node.label + " ");
            }
            JDDConsole.out.print(") ");
        }
        JDDConsole.out.println();
    }
}

