/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.mixedradix;

import jdd.util.Array;
import jdd.util.Test;
import jdd.util.mixedradix.MRSet;
import jdd.util.sets.Set;
import jdd.util.sets.SetEnumeration;
import jdd.util.sets.Universe;

public class MRUniverse
implements Universe {
    int[] subdomains;
    int[] mult;
    private int domain_count;
    private double domain_size;
    static int[] dum = new int[]{3, 4, 5, 1};

    public MRUniverse(int[] nArray) {
        this.subdomains = Array.clone(nArray);
        this.domain_count = nArray.length;
        this.domain_size = 1.0;
        this.mult = new int[this.domain_count];
        for (int i = 0; i < this.domain_count; ++i) {
            this.mult[i] = (int)this.domain_size;
            this.domain_size *= (double)nArray[i];
        }
    }

    @Override
    public void free() {
        this.subdomains = null;
        this.mult = null;
    }

    @Override
    public double domainSize() {
        return this.domain_size;
    }

    @Override
    public int subdomainCount() {
        return this.domain_count;
    }

    @Override
    public Set createEmptySet() {
        return new MRSet(this, false);
    }

    @Override
    public Set createFullSet() {
        return new MRSet(this, true);
    }

    long valueToIndex(int[] nArray) {
        long l = 0L;
        for (int i = 0; i < this.domain_count; ++i) {
            l += (long)(nArray[i] * this.mult[i]);
        }
        return l;
    }

    void indexToValue(long l, int[] nArray) {
        for (int i = 0; i < this.domain_count; ++i) {
            nArray[i] = (int)(l % (long)this.subdomains[i]);
            l /= (long)this.subdomains[i];
        }
    }

    public void randomMember(int[] nArray) {
        for (int i = 0; i < this.domain_count; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.subdomains[i]);
        }
    }

    public static void internal_test() {
        Test.start("MRUniverse");
        MRUniverse mRUniverse = new MRUniverse(dum);
        Set set = mRUniverse.createEmptySet();
        Set set2 = mRUniverse.createFullSet();
        Test.checkEquality(set.cardinality(), 0.0, "Empty set has zero cardinality");
        Test.checkEquality(set2.cardinality(), mRUniverse.domainSize(), "Full set as large as the universe");
        set.free();
        set2.free();
        for (int i = 10; i < 33; ++i) {
            int n;
            set = mRUniverse.createEmptySet();
            for (n = 0; n < i; ++n) {
                mRUniverse.randomMember(dum);
                set.insert(dum);
            }
            Test.checkLessThan((int)set.cardinality(), i + 1, "insert (1)");
            n = 0;
            boolean bl = false;
            SetEnumeration setEnumeration = set.elements();
            while (setEnumeration.hasMoreElements()) {
                ++n;
                int[] nArray = setEnumeration.nextElement();
                if (set.member(nArray)) continue;
                bl = true;
            }
            Test.check(!bl, "SetEnumeration.nextElement() returned a non- member()");
            Test.checkEquality((int)set.cardinality(), n, "MREnumeration (1)");
            set.free();
        }
        Test.end();
    }
}

