<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8" />
<title>phpRsync: a web interface of rsync</title>
<style>
.pointer {
	cursor: pointer;
}
</style>
<link rel="shortcut icon" href="./favicon.ico" type="image/vnd.microsoft.icon" />
<link rel="icon" href="./favicon.ico" type="image/vnd.microsoft.icon" />
</head>
<body>
<a target="_blank" style="color: #888;" href="http://www.gatedruid.com/software/prsync">phpRsync</a>
<hr />
<form method="post">
<?php draw_targets($targets, $delete, $existing, $exclude_from, isset($_POST['label']) ? $_POST['label'] : ''); ?>
<?php if (isset($output->forward)) draw_target('forward', $output->forward, $output->forward_cmd, $output->src, $output->dest); ?>
<?php if (isset($output->reverse)) draw_target('reverse', $output->reverse, $output->reverse_cmd, $output->src, $output->dest); ?>
</form>
</body>
</html>
<?php
function draw_targets($targets, $delete, $existing, $exclude_from, $default)
{
        echo '<select name="label" onchange="this.form.submit();">'."\n";
        foreach ($targets as $target)
        {
                echo '<option value="'.$target->label.'"'.($target->label == $default ? ' selected="selected"' : '').'>'.$target->label.'</option>'."\n";
        }
        $title_exclude_from = "--exclude オプションと似ていますが、代わりに FILE に除外するファイルのリストを記述します。\nFILE の空行と、';' または '#' で始まる行は無視されます。";
        $title_delete = "送信側に存在しない、受信側にあるファイルを削除します。\n転送から除外されたファイルは --delete-excluded を使わない限り削除から除外されます。";
        $title_existing = '新しいファイルを作成しません - つまり、受信側に既に存在するファイルだけを更新します。';
        $title_dry_run = 'ファイル転送を全く行わないで、代わりに実行時の動作だけを表示します。';
        echo '</select>'."\n";
        echo '<input type="hidden" name="exclude_from" value="0" />'."\n";
        echo '<label title="'.$title_exclude_from.'"><input type="checkbox" name="exclude_from" value="1"'.($exclude_from ? ' checked="checked"' : '').' onchange="this.form.submit();" />exclude-from</label>'."\n";
        echo '<input type="hidden" name="delete" value="0" />'."\n";
        echo '<label title="'.$title_delete.'"><input type="checkbox" name="delete" value="1"'.($delete ? ' checked="checked"' : '').' onchange="this.form.submit();" />delete</label>'."\n";
        echo '<input type="hidden" name="existing" value="0" />'."\n";
        echo '<label title="'.$title_existing.'"><input type="checkbox" name="existing" value="1"'.($existing ? ' checked="checked"' : '').' onchange="this.form.submit();" />existing</label>'."\n";
        echo '<input title="'.$title_dry_run.'" type="submit" name="dry_run" value="dry run" />'."\n";
}

function draw_target($direction, $output, $cmd, $src, $dest)
{
        $title_execute = 'dry run ではない、実際の rsync 動作を実行します。';

        $list = FALSE;
        echo '<hr /><strong>'.$direction.'</strong>'."\n";
        if ( ! isset($_POST[$direction]))
        {
                echo '<input title="'.$title_execute.'" type="submit" name="'.$direction.'" value="rsync" onclick="if ( ! confirm(\'Are you sure?\')) return false;" /><br />'."\n";
        }
        echo '<div>'.$cmd.'</div>'."\n";
        foreach (explode("\n", $output) as $value)
        {
                if (preg_match(LIST_UNTIL, $value))
                {
                        $list = FALSE;
                        echo '</div>'."\n";
                }
                if ($list && ! isset($_POST[$direction]))
                {
			$onclick = '';
			if ( ! preg_match('/^deleting /', $value))
			{
				$onclick = ' class="pointer" onclick="window.showModalDialog(\'diff.php?src='.$src.'&dest='.$dest.'&direction='.$direction.'&file='.$value.'\', this, \'dialogWidth=800px; dialogHeight=480px;\');"';
			}
                        echo "<span{$onclick}>".$value.'</span><br />'."\n";
                }
                else
                {
                        echo $value.'<br />'."\n";
                }
                if (preg_match(LIST_FROM, $value))
                {
                        $list = TRUE;
                        echo '<div style="color:'.(isset($_POST[$direction]) ? 'blue' : 'red').';">'."\n";
                }
        }
}
