/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.util;

import java.util.HashMap;
import java.util.Map;

public class Counter {

	private static Map<Object, Long> countByKey = new HashMap<Object, Long>();

	public synchronized static long next(Object key) {
		if (!countByKey.containsKey(key)) {
			countByKey.put(key, 0l);
		}
		long lastCount = countByKey.get(key);
		long newCount;
		if (lastCount == Long.MAX_VALUE) {
			newCount = 0;
		} else {
			newCount = lastCount + 1;
		}
		countByKey.put(key, newCount);
		return lastCount;
	}

	public synchronized static long getCurrent(Object key) {
		return countByKey.get(key);
	}

}
