package com.otk.application.image.filter;

import java.awt.Color;
import java.awt.image.BufferedImage;

import com.otk.application.util.ImageUtils;

public class Temperature extends AbstractFilter {

	public int temperatureChange = 0;

	@Override
	public FilteringContext doExecute(FilteringContext context) {
		BufferedImage srcImage = context.getImage();
		BufferedImage dstImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(),
				ImageUtils.getAdaptedBufferedImageType());
		FastestRGBAccess.transfer(srcImage, dstImage, new FastestRGBAccess.TransferFilter() {
			@Override
			public int get(int x, int y, int rgb, int[] srcPixels) {
				Color color = new Color(rgb, true);
				int red = color.getRed();
				int green = color.getGreen();
				int blue = color.getBlue();

				red = color.getRed() + (temperatureChange * 5);
				red = Math.min(255, Math.max(0, red));

				blue = color.getBlue() - (temperatureChange * 5);
				blue = Math.min(255, Math.max(0, blue));

				color = new Color(red, green, blue, color.getAlpha());
				return color.getRGB();
			}
		});
		return context.withImage(dstImage);
	}

}
