/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import com.otk.application.error.UnexpectedError;
import com.otk.application.util.MathUtils;

public class Saturation extends AbstractSimpleFilter {

	public int amount = 50;

	@Override

	protected int getNewPixelColorComponentValue(char c, BufferedImage im, Point p) {
		Color pixelColor = new Color(im.getRGB(p.x, p.y));
		int currentComponent, otherComponent1, otherComponent2;
		if (c == 'r') {
			currentComponent = pixelColor.getRed();
			otherComponent1 = pixelColor.getGreen();
			otherComponent2 = pixelColor.getBlue();
		} else if (c == 'g') {
			currentComponent = pixelColor.getGreen();
			otherComponent1 = pixelColor.getRed();
			otherComponent2 = pixelColor.getBlue();
		} else if (c == 'b') {
			currentComponent = pixelColor.getBlue();
			otherComponent1 = pixelColor.getGreen();
			otherComponent2 = pixelColor.getRed();
		} else {
			throw new UnexpectedError();
		}
		double diffFromGray = currentComponent - (currentComponent + otherComponent1 + otherComponent2) / 3.0;
		double diffFactor = 2 * amount / 100.0;
		return MathUtils.round(currentComponent - diffFromGray + diffFactor * diffFromGray);
	}

	@Override

	protected boolean isPixelAlterable(BufferedImage srcImage, Point pixelPosition) {
		return true;
	}

	@Override
	protected Object getOptimizationCacheKey(BufferedImage srcImage, Point pixelPosition) {
		return srcImage.getRGB(pixelPosition.x, pixelPosition.y);
	}

}
