/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import com.otk.application.util.ImageUtils;
import com.otk.application.util.MathUtils;

public class CropOrExtend extends AbstractFilter {

	public double centerOffsetX = 0.0;
	public double centerOffsetY = 0.0;
	public double width = 0.5;
	public double height = 0.5;

	@Override
	public FilteringContext doExecute(FilteringContext context) {
		BufferedImage image = context.getImage();
		Rectangle rect = getBounds(image.getWidth(), image.getHeight());
		BufferedImage newImage = ImageUtils.getOverflowingSubImage(image, rect.x, rect.y, rect.width, rect.height);
		return context.withImage(newImage);
	}

	private Rectangle getBounds(int imW, int imH) {
		return getBounds(centerOffsetX, centerOffsetY, width, height, imW, imH);
	}

	public CropOrExtend getInverted() {
		CropOrExtend result = new CropOrExtend();
		result.width = 1.0 / width;
		result.height = 1.0 / height;
		result.centerOffsetX = -result.width * centerOffsetX;
		result.centerOffsetY = -result.height * centerOffsetY;
		return result;
	}

	public static Rectangle getBounds(double windowCenterOffsetX, double windowCenterOffsetY, double windowWidth,
			double windowHeight, int surfaceWidth, int surfaceHeight) {
		double dw = surfaceWidth * windowWidth;
		double dh = surfaceHeight * windowHeight;
		double dCenterX = surfaceWidth * (windowCenterOffsetX + 0.5);
		double dCenterY = surfaceHeight * (windowCenterOffsetY + 0.5);
		return MathUtils.getBoundsAroundCenter(dCenterX, dCenterY, dw, dh).getBounds();
	}
}
