/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import java.awt.image.BufferedImage;

import com.otk.application.util.ImageUtils;
import com.otk.application.util.MathUtils;

public class BoundingBox extends AbstractFilter {

	public int width = 100;
	public int height = 100;
	public boolean scaleToWidth = false;
	public boolean scaleToHeight = false;
	public boolean cutEmptySides = false;

	@Override
	public FilteringContext doExecute(FilteringContext context) {
		BufferedImage image = context.getImage();
		BufferedImage result = null;
		if (scaleToWidth || scaleToHeight) {
			if (scaleToWidth) {
				result = ImageUtils.scaleToWidth(image, width);
				if (!cutEmptySides || (cutEmptySides && (result.getHeight() > height))) {
					int y = MathUtils.round((result.getHeight() - height) / 2.0);
					result = ImageUtils
							.getBufferedImage(ImageUtils.getOverflowingSubImage(result, 0, y, width, height));
				}
			}
			if (scaleToHeight) {
				result = ImageUtils.scaleToHeight(image, height);
				if (!cutEmptySides || (cutEmptySides && (result.getWidth() > width))) {
					int x = MathUtils.round((result.getWidth() - width) / 2.0);
					result = ImageUtils
							.getBufferedImage(ImageUtils.getOverflowingSubImage(result, x, 0, width, height));
				}
			}
		} else {
			result = ImageUtils
					.getBufferedImage(ImageUtils.scalePreservingRatio(image, width, height, cutEmptySides, true));
		}
		return context.withImage(result);
	}
}
