/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import com.otk.application.error.Assertion;

/**
 * A base class for image filters.
 * 
 * @author olitank
 *
 */
public abstract class AbstractFilter {

	public abstract FilteringContext doExecute(FilteringContext context);

	public final FilteringContext execute(final FilteringContext context) {
		final FilteringContext result = doExecute(context);
		Assertion.check(new Assertion.Predicate() {
			@Override
			protected boolean isTrue() {
				return (result == context) || (result.getParent() == context);
			}
		});
		return result;
	}

}
