/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.monitor;

import java.io.File;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor;

public class ProgressSystemoutMonitor
implements CompareMonitor {
    private static String[] progressCharactor = new String[]{" Oo..o ", " Oo..o ", " oOo.. ", " oOo.. ", " .oOo. ", " .oOo. ", " ..oOo ", " ..oOo ", " o..oO ", " o..oO "};
    private int progress = 0;

    private String getProgress() {
        String result = progressCharactor[this.progress];
        ++this.progress;
        if (progressCharactor.length - 1 < this.progress) {
            this.progress = 0;
        }
        return result;
    }

    public void start(CompareSession session) throws CompareException, IllegalConfigurationException {
        System.out.println();
        System.out.println("\u4ee5\u4e0b\u306e\u6761\u4ef6\u3067\u30ea\u30bd\u30fc\u30b9\u306e\u6bd4\u8f03\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
        System.out.println();
        System.out.println("\u6bd4\u8f03\u5143\u30ea\u30bd\u30fc\u30b9 : " + session.getConfigure().getOrigin());
        System.out.println("\u6bd4\u8f03\u5148\u30ea\u30bd\u30fc\u30b9 : " + session.getConfigure().getDestination());
        System.out.println("\u6bd4\u8f03\u7d50\u679c\u51fa\u529b\u5148 : " + session.getConfigure().getResultWritePath());
        System.out.println("\u30ea\u30bd\u30fc\u30b9\u51fa\u529b\u5148 : " + session.getConfigure().getResourceWritePath());
        System.out.println();
        System.out.println("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0   : " + session.getConfigure().getEncoding());
        System.out.println("\u51e6\u7406\u958b\u59cb\u30af\u30e9\u30b9     : " + session.getConfigure().getExecuterClass());
        System.out.println("\u30b3\u30f3\u30c6\u30ca\u30af\u30e9\u30b9     : " + session.getConfigure().getContainerClass());
        System.out.println("\u30d5\u30a3\u30eb\u30bf\u30af\u30e9\u30b9     : " + session.getConfigure().getFilterClass());
        System.out.println("\u30e2\u30cb\u30bf\u30fc\u30af\u30e9\u30b9     : " + session.getConfigure().getMonitorClass());
        System.out.println("\u30b9\u30c8\u30e9\u30c6\u30b8\u30fc\u30af\u30e9\u30b9 : " + session.getConfigure().getStrategyClass());
        System.out.println("\u30ea\u30bd\u30fc\u30b9\u51fa\u529b\u30af\u30e9\u30b9 : " + session.getConfigure().getResourceWriterClass());
        System.out.println("\u6bd4\u8f03\u7d50\u679c\u51fa\u529b\u30af\u30e9\u30b9 : " + session.getConfigure().getResultWriterClass());
        System.out.println();
    }

    public void startCounting(CompareSession session) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u6bd4\u8f03\u5bfe\u8c61\u30ea\u30bd\u30fc\u30b9\u3092\u62bd\u51fa\u3057\u3066\u3044\u307e\u3059 (\u30b9\u30c6\u30fc\u30b8 1/4)...");
        System.out.println(buffer.toString());
    }

    public void counting(CompareSession session, long count) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("  ");
        buffer.append(count);
        buffer.append(" ");
        buffer.append("\u30ea\u30bd\u30fc\u30b9\u304c\u62bd\u51fa\u3055\u308c\u307e\u3057\u305f\u3002");
        System.out.print(buffer.toString());
    }

    public void finishCounting(CompareSession session, long size) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("\u6bd4\u8f03\u5bfe\u8c61\u306e " + size + " \u30ea\u30bd\u30fc\u30b9\u304c\u62bd\u51fa\u3055\u308c\u307e\u3057\u305f\u3002");
        buffer.append("                                        ");
        System.out.println(buffer.toString());
        System.out.println();
    }

    public void startComparing(CompareSession session, long size) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5bfe\u8c61\u306e\u30ea\u30bd\u30fc\u30b9\u306e\u6bd4\u8f03\u3092\u884c\u3063\u3066\u3044\u307e\u3059 (\u30b9\u30c6\u30fc\u30b8 2/4)...");
        System.out.println(buffer.toString());
    }

    public void comparing(CompareSession session, File origin, File destination, boolean originCompare, long count, long size) throws CompareException, IllegalConfigurationException {
        long percent = (long)((double)count / (double)size * 100.0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("  ");
        buffer.append(percent + "% \u5b8c\u4e86\u3057\u307e\u3057\u305f");
        buffer.append(" (");
        buffer.append(size);
        buffer.append(" \u306e\u30ea\u30bd\u30fc\u30b9\u306e\u3046\u3061 ");
        buffer.append(count);
        buffer.append(" \u306e\u6bd4\u8f03\u3092\u884c\u3063\u3066\u3044\u307e\u3059)\u3002 ");
        System.out.print(buffer.toString());
    }

    public void finishComparing(CompareSession session, long size) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("\u6bd4\u8f03\u5bfe\u8c61\u306e " + size + " \u30ea\u30bd\u30fc\u30b9\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        buffer.append("                                        ");
        System.out.println(buffer.toString());
        System.out.println();
    }

    public void startResultWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u6bd4\u8f03\u7d50\u679c\u60c5\u5831\u306e\u51fa\u529b\u3092\u884c\u3063\u3066\u3044\u307e\u3059 (\u30b9\u30c6\u30fc\u30b8 3/4)...");
        System.out.println(buffer.toString());
    }

    public void resultWriting(CompareSession session, long count, long size) throws CompareException, IllegalConfigurationException {
        long percent = (long)((double)count / (double)size * 100.0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("  ");
        buffer.append(percent + "% \u5b8c\u4e86\u3057\u307e\u3057\u305f");
        buffer.append(" (");
        buffer.append(size);
        buffer.append(" \u306e\u30ea\u30bd\u30fc\u30b9\u306e\u3046\u3061 ");
        buffer.append(count);
        buffer.append(" \u306e\u60c5\u5831\u51fa\u529b\u3092\u884c\u3063\u3066\u3044\u307e\u3059)\u3002 ");
        System.out.print(buffer.toString());
    }

    public void finishResultWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("\u6bd4\u8f03\u7d50\u679c\u60c5\u5831\u306e\u51fa\u529b\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        buffer.append("                                        ");
        System.out.println(buffer.toString());
        System.out.println();
    }

    public void startResourceWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u6bd4\u8f03\u7d50\u679c\u30ea\u30bd\u30fc\u30b9\u306e\u51fa\u529b\u3092\u884c\u3063\u3066\u3044\u307e\u3059 (\u30b9\u30c6\u30fc\u30b8 4/4)...");
        System.out.println(buffer.toString());
    }

    public void resourceWriting(CompareSession session, long count, long size) throws CompareException, IllegalConfigurationException {
        long percent = (long)((double)count / (double)size * 100.0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("  ");
        buffer.append(percent + "% \u5b8c\u4e86\u3057\u307e\u3057\u305f");
        buffer.append(" (");
        buffer.append(size);
        buffer.append(" \u306e\u30ea\u30bd\u30fc\u30b9\u306e\u3046\u3061 ");
        buffer.append(count);
        buffer.append(" \u306e\u30ea\u30bd\u30fc\u30b9\u51fa\u529b\u3092\u884c\u3063\u3066\u3044\u307e\u3059)\u3002 ");
        System.out.print(buffer.toString());
    }

    public void finishResourceWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\r");
        buffer.append("\u6bd4\u8f03\u7d50\u679c\u30ea\u30bd\u30fc\u30b9\u306e\u51fa\u529b\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        buffer.append("                                        ");
        System.out.println(buffer.toString());
        System.out.println();
    }

    public void finish(CompareSession session) throws CompareException, IllegalConfigurationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u30ea\u30bd\u30fc\u30b9\u6bd4\u8f03\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        System.out.println(buffer.toString());
        System.out.println();
    }
}

