/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.core.enumeration;

import java.io.Serializable;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;

public final class Status
implements Serializable {
    private int code;
    private String name;
    private static final String NAME_UNSETTING = "Unsetting";
    private static final String NAME_SAME = "Same";
    private static final String NAME_ADD = "Add";
    private static final String NAME_UPDATE = "Update";
    private static final String NAME_DELETE = "Delete";
    private static final int CODE_UNSETTING = 0;
    private static final int CODE_SAME = 1;
    private static final int CODE_ADD = 2;
    private static final int CODE_UPDATE = 3;
    private static final int CODE_DELETE = 4;
    public static final Status UNSETTING = new Status(0, "Unsetting");
    public static final Status SAME = new Status(1, "Same");
    public static final Status ADD = new Status(2, "Add");
    public static final Status UPDATE = new Status(3, "Update");
    public static final Status DELETE = new Status(4, "Delete");

    private Status() {
    }

    private Status(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Status valueOf(String code) throws IllegalEnumerationException {
        if (NAME_SAME.equalsIgnoreCase(code)) {
            return SAME;
        }
        if (NAME_ADD.equalsIgnoreCase(code)) {
            return ADD;
        }
        if (NAME_UPDATE.equalsIgnoreCase(code)) {
            return UPDATE;
        }
        if (NAME_DELETE.equalsIgnoreCase(code)) {
            return DELETE;
        }
        throw new IllegalEnumerationException("Illegal Code : " + code);
    }

    public static Status valueOf(int code) throws IllegalEnumerationException {
        if (1 == code) {
            return SAME;
        }
        if (2 == code) {
            return ADD;
        }
        if (3 == code) {
            return UPDATE;
        }
        if (4 == code) {
            return DELETE;
        }
        throw new IllegalEnumerationException("Illegal Code : " + code);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Status other = (Status)object;
        return this.code == other.code;
    }

    public String toString() {
        return this.name;
    }
}

