package org.phosphoresce.resourcecomp.plugin.writer;

import java.io.File;
import java.util.Iterator;
import java.util.List;

import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.util.FileUtil;

/**
 * r\[Xt@Co̓NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/13	Kitagawa		VK쐬
 *-->
 */
public class ResourceFileWriter extends ResourceAbstractWriter {

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 * @param status o͑ΏۃXe[^X
	 */
	public ResourceFileWriter(CompareSession session, Status[] status) {
		super(session, status);
	}

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 */
	public ResourceFileWriter(CompareSession session) {
		super(session);
	}

	/**
	 * r\[Xo͂܂B<br>
	 * @throws CompareException ɏo͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.writer.ResourceAbstractWriter#write()
	 */
	public void write() throws CompareException {
		try {
			CompareConfigure configure = session.getConfigure();
			FileUtil.getFilePath(configure.getResourceWritePath()).mkdirs();

			// o͐pX␳
			String writePath = configure.getResourceWritePath().getCanonicalPath();
			writePath = writePath.endsWith(File.separator) ? writePath : writePath + File.separator;

			List targets = session.getContainer().getResourceList(status);
			size = targets.size();
			count = 0;

			for (Iterator iterator = targets.iterator(); iterator.hasNext();) {
				Resource resource = (Resource) iterator.next();

				count++;

				Status[] status = configure.getTargetStatus();
				boolean validate = false;
				for (int i = 0; i <= status.length - 1; i++) {
					if (resource.getStatus() == Status.DELETE) {
						validate = false;
						break;
					}
					if (resource.getStatus() == status[i]) {
						validate = true;
						break;
					}
				}

				if (validate) {
					File file = resource.getDestination();
					String path = writePath + file.getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
					String name = file.getName();
					File directory = new File(path.substring(0, path.length() - name.length()));
					if (!directory.exists()) {
						directory.mkdirs();
					}
					FileUtil.copy(file, new File(path));
				}
			}
		} catch (Throwable e) {
			throw new CompareException("\[Xo͎ɗ\ʗO܂", e);
		}
	}
}
