package org.phosphoresce.resourcecomp.plugin.strategy;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.util.StringUtil;

/**
 * r`F[XgeWNX<br>
 * <br>
 * NX͎spXrcomp-chaining-strategy.properties݂ꍇANXꂽ^C~O
 * Propertiest@Cɒ`ĂŃNX܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public final class ChainingStrategy implements CompareStrategy {

	/** rXgeWXg */
	private List list;

	/**
	 * RXgN^<br>
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	public ChainingStrategy() throws IllegalConfigurationException {
		super();
		this.list = new LinkedList();
		load();
	}

	/**
	 * vpeBt@Cݒǂݍ݂܂B<br>
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	private void load() throws IllegalConfigurationException {
		try {
			if (!new File("rcomp-chaining-strategy.properties").exists()) {
				return;
			}
			FileInputStream stream = new FileInputStream("rcomp-chaining-strategy.properties");
			Properties properties = new Properties();
			properties.load(stream);
			{
				String value = properties.getProperty("classes");
				value = value.replaceAll("\\n\\r", "");
				for (StringTokenizer tokenizer = new StringTokenizer(value, ","); tokenizer.hasMoreTokens();) {
					String token = tokenizer.nextToken().trim();
					if (!StringUtil.isEmpty(token)) {
						add(Class.forName(token));
					}
				}
			}
			stream.close();
		} catch (Throwable e) {
			throw new IllegalConfigurationException("ɊݒsƂo܂ł", e);
		}
	}

	/**
	 * rXgeWIuWFNgǉ܂B<br>
	 * @param strategy rXgeWIuWFNg
	 */
	public void add(CompareStrategy strategy) {
		if (!list.contains(strategy)) {
			list.add(strategy);
		}
	}

	/**
	 * rXgeWIuWFNgǉ܂B<br>
	 * @param strategy rXgeWIuWFNg
	 * @throws IllegalConfigurationException 
	 */
	public void add(Class strategy) throws IllegalConfigurationException {
		try {
			Constructor constructor = strategy.getConstructor(new Class[] {});
			Object object = constructor.newInstance(new Object[] {});
			if (!(object instanceof CompareStrategy)) {
				throw new IllegalConfigurationException("rXgeWC^tF[XȂNXw肳܂");
			}
			if (!list.contains(object)) {
				list.add(object);
			}
		} catch (Throwable e) {
			throw new IllegalConfigurationException("rXgeWNX̒ǉɎs܂", e);
		}
	}

	/**
	 * rXgeWIuWFNg폜܂B<br>
	 * @param strategy rXgeWIuWFNg
	 */
	public void remove(CompareStrategy strategy) {
		if (list.contains(strategy)) {
			list.remove(strategy);
		}
	}

	/**
	 * rXgeWIuWFNgSč폜܂B<br>
	 */
	public void clear() {
		list.clear();
	}

	/**
	 * ێĂrXgeW擾܂B<br>
	 * @return ێĂrXgeW
	 */
	public int size() {
		return list.size();
	}

	/**
	 * w肳ꂽ\[Xm̔rsǍʂԋp܂B<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return ʃXe[^X
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy#compare(java.io.File, java.io.File)
	 */
	public Status compare(File origin, File destination) throws CompareException {
		if (list.size() <= 0) {
			throw new CompareException("rXgeW1w肳Ă܂");
		}
		Status status = Status.SAME;
		for (Iterator iterator = list.iterator(); iterator.hasNext();) {
			CompareStrategy strategy = (CompareStrategy) iterator.next();
			Status result = strategy.compare(origin, destination);
			if (status == Status.SAME) {
				status = result;
			}
		}
		return status;
	}
}
