package org.phosphoresce.resourcecomp.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;

import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

/**
 * t@C샆[eBeBNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public final class FileUtil {

	/**
	 * RXgN^<br>
	 */
	private FileUtil() {
		super();
	}

	/**
	 * w肳ꂽfBNg\[Xz̃t@CIuWFNg擾܂B<br>
	 * @param directory fBNg\[X
	 * @return fBNg\[Xz̃t@CIuWFNg
	 * @throws ResourceOperateException sȃfBNg\[Xw肵ꍇɔ
	 */
	public static final File[] getFiles(File directory) throws ResourceOperateException {
		if (directory == null || !directory.isDirectory()) {
			throw new ResourceOperateException("fBNgł͂Ȃt@CIuWFNgw肳܂[" + directory + "]");
		}
		return directory.listFiles(new FileFilter() {
			/**
			 * w肳ꂽ\[XtB^[eł邩肵܂B<br>
			 * @param file Ώۃ\[X
			 * @return e\[Xłꍇtrueԋp
			 * @see java.io.FileFilter#accept(java.io.File)
			 */
			public boolean accept(File file) {
				return file.isFile();
			}
		});
	}

	/**
	 * w肳ꂽfBNg\[Xz̃fBNgIuWFNg擾܂B<br>
	 * @param directory fBNg\[X
	 * @return fBNg\[Xz̃fBNgIuWFNg
	 * @throws ResourceOperateException sȃfBNg\[Xw肵ꍇɔ
	 */
	public static final File[] getDirectories(File directory) throws ResourceOperateException {
		if (directory == null || !directory.isDirectory()) {
			throw new ResourceOperateException("fBNgł͂Ȃt@CIuWFNgw肳܂");
		}
		return directory.listFiles(new FileFilter() {
			/**
			 * w肳ꂽ\[XtB^[eł邩肵܂B<br>
			 * @param file Ώۃ\[X
			 * @return e\[Xłꍇtrueԋp
			 * @see java.io.FileFilter#accept(java.io.File)
			 */
			public boolean accept(File file) {
				return file.isDirectory();
			}
		});
	}

	/**
	 * w肳ꂽt@C̏fBNg擾܂B<br>
	 * @param file Ώۃt@C
	 * @return t@C̏fBNg
	 * @throws ResourceOperateException ɃfBNg̎擾oȂꍇɔ
	 */
	public static final File getFilePath(File file) throws ResourceOperateException {
		try {
			String path = file.getCanonicalPath();
			path = path.substring(0, path.lastIndexOf(File.separator));
			return new File(path);
		} catch (Throwable e) {
			throw new ResourceOperateException("t@CfBNg̎擾Ɏs܂", e);
		}
	}

	/**
	 * w肳ꂽ̓t@CRs[܂B<br>
	 * @param input ̓t@C
	 * @param output o̓t@C
	 * @throws ResourceOperateException Ƀt@CRs[sȂꍇɔ
	 */
	public static void copy(File input, File output) throws ResourceOperateException {
		try {
			FileChannel inputChannel = new FileInputStream(input).getChannel();
			FileChannel outputChannel = new FileOutputStream(output).getChannel();
			inputChannel.transferTo(0, inputChannel.size(), outputChannel);
			inputChannel.close();
			outputChannel.close();
		} catch (Throwable e) {
			throw new ResourceOperateException("t@C̃Rs[Ɏs܂", e);
		}
	}
}
