package org.phosphoresce.resourcecomp.plugin.strategy;

import java.io.File;

import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.CompareException;

/**
 * rXgeWʒۃNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/16	Kitagawa		VK쐬
 *-->
 */
public abstract class CompareAbstractStrategy implements CompareStrategy {

	/**
	 * RXgN^<br>
	 */
	public CompareAbstractStrategy() {
		super();
	}

	/**
	 * w肳ꂽ\[Xm̔rsǍʂԋp܂B<br>
	 * \bh͉ʃNXŕKvɉăI[o[Ch邱Ƃ\łB<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return ʃXe[^X
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy#compare(java.io.File, java.io.File)
	 */
	public Status compare(File origin, File destination) throws CompareException {
		if (isSame(origin, destination)) {
			return Status.SAME;
		} else if (isAdded(origin, destination)) {
			return Status.ADD;
		} else if (isDeleted(origin, destination)) {
			return Status.DELETE;
		} else if (isUpdate(origin, destination)) {
			return Status.UPDATE;
		} else {
			return Status.SAME;
		}
	}

	/**
	 * r惊\[XύXԂł邩𔻒肵܂B<br>
	 * \bh͉ʃNXŕKvɉăI[o[Ch邱Ƃ\łB<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return r惊\[XύXԂłꍇtrueԋp
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 */
	protected boolean isSame(File origin, File destination) throws CompareException {
		if (origin == null && destination == null) {
			return true;
		} else if (origin != null && destination != null && origin.isDirectory() && destination.isDirectory()) {
			return true;
		}
		return false;
	}

	/**
	 * r惊\[XǉԂł邩𔻒肵܂B<br>
	 * \bh͉ʃNXŕKvɉăI[o[Ch邱Ƃ\łB<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return r惊\[XǉԂłꍇtrueԋp
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 */
	protected boolean isAdded(File origin, File destination) throws CompareException {
		if (origin == null && destination != null && destination.exists()) {
			return true;
		} else if (origin != null && !origin.exists() && destination != null && destination.exists()) {
			return true;
		}
		return false;
	}

	/**
	 * r惊\[X폜Ԃł邩𔻒肵܂B<br>
	 * \bh͉ʃNXŕKvɉăI[o[Ch邱Ƃ\łB<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return r惊\[X폜Ԃłꍇtrueԋp
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 */
	protected boolean isDeleted(File origin, File destination) throws CompareException {
		if (destination == null && origin != null && origin.exists()) {
			return true;
		} else if (destination != null && !destination.exists() && origin != null && origin.exists()) {
			return true;
		}
		return false;
	}

	/**
	 * r惊\[X폜Ԃł邩𔻒肵܂B<br>
	 * \bh͉ʃNXŕKvɉăI[o[Ch邱Ƃ\łB<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return r惊\[X폜Ԃłꍇtrueԋp
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 */
	protected abstract boolean isUpdate(File origin, File destination) throws CompareException;
}
