package org.phosphoresce.resourcecomp.core.enumeration;

import java.io.Serializable;

import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;

/**
 * \[X^CvNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public final class Type implements Serializable {

	/** ^CvR[h */
	private int code;

	/** ^Cv */
	private String name;

	/** t@CR[h */
	private static final String NAME_FILE = "File";

	/** fBNgR[h */
	private static final String NAME_DIRECTORY = "Directory";

	/** t@CR[h */
	private static final int CODE_FILE = 0;

	/** fBNgR[h */
	private static final int CODE_DIRECTORY = 1;

	/** t@C */
	public static final Type FILE = new Type(CODE_FILE, NAME_FILE);

	/** fBNg */
	public static final Type DIRECTORY = new Type(CODE_DIRECTORY, NAME_DIRECTORY);

	/**
	 * RXgN^<br>
	 */
	private Type() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param code ^CvR[h
	 * @param name ^Cv
	 */
	private Type(int code, String name) {
		super();
		this.code = code;
		this.name = name;
	}

	/**
	 * w肳ꂽR[h^Cv擾܂B<br>
	 * @param code R[h
	 * @return ^Cv
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	public static Type valueOf(String code) throws IllegalEnumerationException {
		if (NAME_FILE.equalsIgnoreCase(code)) {
			return FILE;
		} else if (NAME_DIRECTORY.equalsIgnoreCase(code)) {
			return DIRECTORY;
		} else {
			throw new IllegalEnumerationException("Illegal Code : " + code);
		}
	}

	/**
	 * w肳ꂽR[h^Cv擾܂B<br>
	 * @param code R[h
	 * @return ^Cv
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	public static Type valueOf(int code) throws IllegalEnumerationException {
		if (CODE_FILE == code) {
			return FILE;
		} else if (CODE_DIRECTORY == code) {
			return DIRECTORY;
		} else {
			throw new IllegalEnumerationException("Illegal Code : " + code);
		}
	}

	/**
	 * IuWFNgnbVR[h擾܂B<br>
	 * @return IuWFNgnbVR[h
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + code;
		return result;
	}

	/**
	 * IuWFNg̔rs܂B<br>
	 * @param object rΏۃIuWFNg
	 * @return ̏ꍇtrueԋp
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		final Type other = (Type) object;
		if (code != other.code) {
			return false;
		}
		return true;
	}

	/**
	 * IuWFNg𕶎ƂĒ񋟂܂B<br>
	 * @return IuWFNg񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return name;
	}
}
