/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

public final class FileUtil {
    private FileUtil() {
    }

    public static final File[] getFiles(File directory) throws ResourceOperateException {
        if (directory == null || !directory.isDirectory()) {
            throw new ResourceOperateException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f[" + directory + "]");
        }
        return directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        });
    }

    public static final File[] getDirectories(File directory) throws ResourceOperateException {
        if (directory == null || !directory.isDirectory()) {
            throw new ResourceOperateException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        return directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static final File getFilePath(File file) throws ResourceOperateException {
        try {
            String path = file.getCanonicalPath();
            path = path.substring(0, path.lastIndexOf(File.separator));
            return new File(path);
        }
        catch (Throwable e) {
            throw new ResourceOperateException("\u30d5\u30a1\u30a4\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public static void copy(File input, File output) throws ResourceOperateException {
        try {
            FileChannel inputChannel = new FileInputStream(input).getChannel();
            FileChannel outputChannel = new FileOutputStream(output).getChannel();
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
            inputChannel.close();
            outputChannel.close();
        }
        catch (Throwable e) {
            throw new ResourceOperateException("\u30d5\u30a1\u30a4\u30eb\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }
}

