/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.writer;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.plugin.writer.ResultAbstractWriter;
import org.phosphoresce.resourcecomp.util.FileUtil;

public final class ResultCVSWriter
extends ResultAbstractWriter {
    public ResultCVSWriter(CompareSession session, Status[] status) {
        super(session, status);
    }

    public ResultCVSWriter(CompareSession session) {
        super(session);
    }

    public void write() throws CompareException {
        try {
            CompareConfigure configure = this.session.getConfigure();
            FileUtil.getFilePath(configure.getResultWritePath()).mkdirs();
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(configure.getResultWritePath()));
            writer.write("\u30b9\u30c6\u30fc\u30bf\u30b9");
            writer.write(",");
            writer.write("\u30ea\u30bd\u30fc\u30b9");
            writer.write(",");
            writer.write("\u30b5\u30a4\u30ba");
            writer.write(",");
            writer.write("\u66f4\u65b0\u65e5\u6642");
            writer.write("\n");
            List targets = this.session.getContainer().getResourceList(this.status);
            this.size = targets.size();
            this.count = 0L;
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                ++this.count;
                String path = "";
                String size = "";
                String date = "";
                if (resource.getStatus() == Status.ADD) {
                    path = resource.getDestination().getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
                    size = String.valueOf(resource.getDestination().length());
                    date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getDestination().lastModified()));
                } else if (resource.getStatus() == Status.DELETE) {
                    path = resource.getOrigin().getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
                    size = String.valueOf(resource.getOrigin().length());
                    date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getOrigin().lastModified()));
                } else if (resource.getStatus() == Status.UPDATE) {
                    path = resource.getOrigin().getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
                    size = String.valueOf(resource.getOrigin().length());
                    date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getOrigin().lastModified()));
                } else {
                    if (resource.getStatus() != Status.SAME) continue;
                    path = resource.getOrigin().getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
                    size = String.valueOf(resource.getOrigin().length());
                    date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getOrigin().lastModified()));
                }
                Status[] status = configure.getTargetStatus();
                boolean validate = false;
                for (int i = 0; i <= status.length - 1; ++i) {
                    if (resource.getStatus() != status[i]) continue;
                    validate = true;
                    break;
                }
                if (validate) {
                    writer.write(resource.getStatus().toString());
                    writer.write(",");
                    writer.write(path);
                    writer.write(",");
                    writer.write(size);
                    writer.write(",");
                    writer.write(date);
                    writer.write("\n");
                }
                writer.flush();
            }
            writer.close();
        }
        catch (Throwable e) {
            throw new CompareException("\u6bd4\u8f03\u7d50\u679c\u51fa\u529b\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

