/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.strategy;

import java.io.File;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy;

public abstract class CompareAbstractStrategy
implements CompareStrategy {
    public Status compare(File origin, File destination) throws CompareException {
        if (this.isSame(origin, destination)) {
            return Status.SAME;
        }
        if (this.isAdded(origin, destination)) {
            return Status.ADD;
        }
        if (this.isDeleted(origin, destination)) {
            return Status.DELETE;
        }
        if (this.isUpdate(origin, destination)) {
            return Status.UPDATE;
        }
        return Status.SAME;
    }

    protected boolean isSame(File origin, File destination) throws CompareException {
        if (origin == null && destination == null) {
            return true;
        }
        return origin != null && destination != null && origin.isDirectory() && destination.isDirectory();
    }

    protected boolean isAdded(File origin, File destination) throws CompareException {
        if (origin == null && destination != null && destination.exists()) {
            return true;
        }
        return origin != null && !origin.exists() && destination != null && destination.exists();
    }

    protected boolean isDeleted(File origin, File destination) throws CompareException {
        if (destination == null && origin != null && origin.exists()) {
            return true;
        }
        return destination != null && !destination.exists() && origin != null && origin.exists();
    }

    protected abstract boolean isUpdate(File var1, File var2) throws CompareException;
}

