/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.filter;

import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilter;
import org.phosphoresce.resourcecomp.util.StringUtil;

public class ResourceIgnoreFilter
implements CompareResourceFilter {
    private List values = new LinkedList();
    private List regexps = new LinkedList();

    public ResourceIgnoreFilter() throws IllegalConfigurationException {
        this.load();
    }

    private void load() throws IllegalConfigurationException {
        try {
            if (!new File("rcomp-ignore-filter.properties").exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream("rcomp-ignore-filter.properties");
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("value");
            value = value.replaceAll("\\n\\r", "");
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (StringUtil.isEmpty(token)) continue;
                String ignore = token.indexOf("/") >= 0 ? token.substring(0, token.indexOf("/")) : token;
                boolean regexp = token.indexOf("/") >= 0 ? Boolean.getBoolean(token.substring(token.indexOf("/") + 1)) : false;
                this.add(ignore, regexp);
            }
            stream.close();
        }
        catch (Throwable e) {
            throw new IllegalConfigurationException("\u6b63\u5e38\u306b\u74b0\u5883\u8a2d\u5b9a\u3092\u884c\u3046\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public void add(String value, boolean regexp) {
        this.values.add(value);
        this.regexps.add(new Boolean(regexp));
    }

    public boolean accept(File file) throws ResourceOperateException {
        try {
            for (int i = 0; i <= this.values.size() - 1; ++i) {
                String value = (String)this.values.get(i);
                boolean regexp = (Boolean)this.regexps.get(i);
                boolean match = false;
                if (regexp) {
                    match = file.getCanonicalPath().matches(value);
                } else {
                    boolean bl = match = file.getCanonicalPath().indexOf(value) >= 0;
                }
                if (!match) continue;
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            throw new ResourceOperateException("\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u30a2\u30af\u30bb\u30b9\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

