package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.Icon;

import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * DatabaseBrowsert[plʃNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/27	Kitagawa		VK쐬
 *-->
 */
public abstract class BrowserFramePanel extends EPanel implements RefreshableComponent {

	/** wb_pl */
	private FrameHeaderPanel frameHeaderPanel = null;

	/** RecyC */
	private EPanel contentPanel = null;

	/**
	 * RXgN^<br>
	 */
	public BrowserFramePanel() {
		super();
	}

	/**
	 * t[wb_^Cg擾܂B<br>
	 * @return t[wb_^Cg
	 */
	public abstract String getHeaderTitle();

	/**
	 * t[wb_ڍ׃bZ[W擾܂B<br>
	 * @return t[wb_ڍ׃bZ[W
	 */
	public abstract String getHeaderDescription();

	/**
	 * t[wb_ACR擾܂B<br>
	 * @return t[wb_ACR
	 */
	public abstract Icon getHeaderIcon();

	/**
	 * t[yCRecpl𐶐܂B<br>
	 * @return t[yCRecpl
	 */
	protected abstract EPanel createContentPanel();

	/**
	 * R|[lgs܂B<br>
	 */
	protected final void initialize() {
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 1.0;
		gridBagConstraints3.weighty = 0.0;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 2;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0;
		gridBagConstraints2.weighty = 1.0;
		gridBagConstraints2.gridy = 1;
		gridBagConstraints2.gridx = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 1.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(800, 800));
		this.add(getFrameHeaderPanel(), gridBagConstraints1);
		this.add(getContentPanel(), gridBagConstraints2);
	}

	/**
	 * wb_pl擾܂B<br>
	 * @return wb_pl
	 */
	protected final FrameHeaderPanel getFrameHeaderPanel() {
		if (frameHeaderPanel == null) {
			frameHeaderPanel = new FrameHeaderPanel();
			frameHeaderPanel.setText(getHeaderTitle());
			frameHeaderPanel.setHedaerIcon(getHeaderIcon());
			frameHeaderPanel.setDescription(getHeaderDescription());
		}
		return frameHeaderPanel;
	}

	/**
	 * Recpl擾܂B<br>
	 * @return Recpl
	 */
	protected final EPanel getContentPanel() {
		if (contentPanel == null) {
			contentPanel = createContentPanel();
		}
		return contentPanel;
	}
}
