package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;

import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserEBhER|[lgݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/08	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserWindowComponentConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "windowComponent";

	/** bZ[WyCP[V */
	private int messagePaneLocation;

	/** NG}l[Wݒ */
	private DatabaseBrowserWindowComponentQueryManageConfig queryManageConfig;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserWindowComponentConfig() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param root [gm[h
	 */
	DatabaseBrowserWindowComponentConfig(Node root) {
		super();
		initialize();
		load(root);
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		messagePaneLocation = 80;
		queryManageConfig = new DatabaseBrowserWindowComponentQueryManageConfig();
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		Node messagePaneLocation = node.appendChild(document.createElement("messagePaneLocation"));
		messagePaneLocation.appendChild(document.createTextNode(StringUtil.valueOf(getMessagePaneLocation())));

		getQueryManageConfig().save(document, node);
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if ("messagePaneLocation".equals(node.getNodeName())) {
				messagePaneLocation = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			}
			if (DatabaseBrowserWindowComponentQueryManageConfig.NODE_NAME.equals(node.getNodeName())) {
				queryManageConfig = new DatabaseBrowserWindowComponentQueryManageConfig(node);
			}
		}
	}

	/**
	 * bZ[WyCP[V擾܂B<br>
	 * @return bZ[WyCP[V
	 */
	public int getMessagePaneLocation() {
		return messagePaneLocation;
	}

	/**
	 * bZ[WyCP[Vݒ肵܂B<br>
	 * @param messagePaneLocation bZ[WyCP[V
	 */
	public void setMessagePaneLocation(int messagePaneLocation) {
		this.messagePaneLocation = messagePaneLocation;
	}

	/**
	 * NG}l[Wݒ擾܂B<br>
	 * @return NG}l[Wݒ
	 */
	public DatabaseBrowserWindowComponentQueryManageConfig getQueryManageConfig() {
		return queryManageConfig;
	}

	/**
	 * NG}l[Wݒݒ肵܂B<br>
	 * @param queryManageConfig NG}l[Wݒ
	 */
	public void setQueryManageConfig(DatabaseBrowserWindowComponentQueryManageConfig queryManageConfig) {
		this.queryManageConfig = queryManageConfig;
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserWindowComponentConfig{");
		buffer.append("messagePaneLocation=");
		buffer.append(getMessagePaneLocation());
		buffer.append(",");
		buffer.append("queryManageConfig=");
		buffer.append(getQueryManageConfig());
		buffer.append("}");
		return buffer.toString();
	}
}
